% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infotheo.R
\name{infotheo}
\alias{infotheo}
\alias{infotheo.default}
\alias{infotheo.formula}
\title{Information-theoretic meta-features}
\usage{
infotheo(...)

\method{infotheo}{default}(
  x,
  y,
  features = "all",
  summary = c("mean", "sd"),
  transform = TRUE,
  ...
)

\method{infotheo}{formula}(
  formula,
  data,
  features = "all",
  summary = c("mean", "sd"),
  transform = TRUE,
  ...
)
}
\arguments{
\item{...}{Further arguments passed to the summarization functions.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{features}{A list of features names or \code{"all"} to include all them.
The supported values are described in the details section. (Default: 
\code{"all"})}

\item{summary}{A list of summarization functions or empty for all values. See
\link{post.processing} method to more information. (Default: 
\code{c("mean", "sd")})}

\item{transform}{A logical value indicating if the numeric attributes should 
be transformed. If \code{FALSE} they will be ignored. (Default: 
\code{TRUE})}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class
The details section describes the valid values for this group.}
}
\value{
A list named by the requested meta-features.
}
\description{
Information-theoretic meta-features are particularly appropriate to describe
discrete (categorical) attributes, but they also fit continuous ones so a
discretization is required.
}
\details{
The following features are allowed for this method:
 \describe{
   \item{"attrConc"}{Attributes concentration. It is the Goodman and 
     Kruskal's tau measure otherwise known as the concentration coefficient
     computed for each pair of attributes (multi-valued).}
   \item{"attrEnt"}{Attributes entropy, a measure of randomness of each 
     attributes in the dataset (multi-valued).}
   \item{"classConc"}{Class concentration, similar to "attrConc", however, it
     is computed for each attribute and the class (multi-valued).}
   \item{"classEnt"}{Class entropy, which describes how much information is 
     necessary to specify the class in the dataset.}
   \item{"eqNumAttr"}{Equivalent number of attributes, which represents the 
     number of attributes suitable to optimally solve the classification task
     using the dataset.}
   \item{"jointEnt"}{Joint entropy, which represents the total entropy of 
     each attribute and the class (multi-valued).}
   \item{"mutInf"}{Mutual information, that is the common information shared
     between each attribute and the class in the dataset (multi-valued).}
   \item{"nsRatio"}{Noise ratio, which describes the amount of irrelevant 
     information contained in the dataset.}
 }
 This method uses the unsupervised data discretization procedure provided by
 \link[infotheo]{discretize} function, where the default values are used when
 \code{transform=TRUE}.
}
\examples{
## Extract all metafeatures
infotheo(Species ~ ., iris)

## Extract some metafeatures
infotheo(iris[1:4], iris[5], c("classEnt", "jointEnt"))

## Extract all meta-features without summarize the results
infotheo(Species ~ ., iris, summary=c())

## Use another summarization functions
infotheo(Species ~ ., iris, summary=c("min", "median", "max"))

## Do not transform the data (using only categorical attributes)
infotheo(Species ~ ., iris, transform=FALSE)
}
\references{
Donald Michie, David J. Spiegelhalter, Charles C. Taylor, and John Campbell. 
 Machine Learning, Neural and Statistical Classification, volume 37. Ellis 
 Horwood Upper Saddle River, 1994.

 Alexandros Kalousis and Melanie Hilario. Model selection via meta-learning: 
 a comparative study. International Journal on Artificial Intelligence Tools,
 volume 10, pages 525 - 554, 2001.

 Ciro Castiello, Giovanna Castellano, and Anna Maria Fanelli. Meta-data: 
 Characterization of input features for meta-learning. In 2nd International 
 Conference on Modeling Decisions for Artificial Intelligence (MDAI), 
 pages 457 - 468, 2005.
}
\seealso{
Other meta-features: 
\code{\link{clustering}()},
\code{\link{complexity}()},
\code{\link{concept}()},
\code{\link{general}()},
\code{\link{itemset}()},
\code{\link{landmarking}()},
\code{\link{model.based}()},
\code{\link{relative}()},
\code{\link{statistical}()}
}
\concept{meta-features}
