% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdd.R
\name{mdd.mfbvar_ss}
\alias{mdd.mfbvar_ss}
\title{Marginal data density method for class \code{mfbvar_ss}}
\usage{
\method{mdd}{mfbvar_ss}(x, method = 1, ...)
}
\arguments{
\item{x}{object of class \code{mfbvar_ss}}

\item{method}{option for which method to choose for computing the mdd (\code{1} or \code{2})}

\item{...}{additional arguments (currently only \code{p_trunc} for the degree of truncation for method 2 is available)}
}
\value{
The logarithm of the marginal data density.
}
\description{
Estimate the marginal data density for the model with a steady-state prior.
}
\details{
Two methods for estimating the marginal data density are implemented. Method 1 and 2 correspond to the two methods proposed by
Fuentes-Albero and Melosi (2013) and Ankargren, Unosson and Yang (2018).
}
\references{
Fuentes-Albero, C. and Melosi, L. (2013) Methods for Computing Marginal Data Densities from the Gibbs Output.
\emph{Journal of Econometrics}, 175(2), 132-141, \url{https://doi.org/10.1016/j.jeconom.2013.03.002}\cr
 Ankargren, S., Unosson, M., & Yang, Y. (2018) A Mixed-Frequency Bayesian Vector Autoregression with a Steady-State Prior. Working Paper, Department of Statistics, Uppsala University No. 2018:3.
}
\seealso{
\code{\link{mdd}}, \code{\link{mdd.mfbvar_minn}}
}
