% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taildep.R
\name{taildep}
\alias{taildep}
\title{Coefficient of tail correlation and tail dependence}
\usage{
taildep(
  xdat,
  qlev = NULL,
  nq = 40,
  qlim = c(0.8, 0.99),
  depmeas = c("eta", "chi"),
  estimator = list(eta = c("emp", "betacop", "gpd", "hill"), chi = c("emp", "betacop")),
  confint = c("wald", "lrt"),
  level = 0.95,
  trunc = TRUE,
  margtrans = c("emp", "none"),
  ties.method = "random",
  plot = TRUE,
  ...
)
}
\arguments{
\item{xdat}{an \eqn{n} by \eqn{d} matrix of multivariate observations}

\item{qlev}{vector of percentiles between 0 and 1}

\item{nq}{number of quantiles of the structural variable at which to form a grid; only used if \code{u = NULL}.}

\item{qlim}{limits for the sequence \code{u} of the structural variable}

\item{depmeas}{dependence measure, either of \code{"eta"} or \code{"chi"}}

\item{estimator}{named list giving the estimation method for \code{eta} and \code{chi}. Default to \code{"emp"} for both.}

\item{confint}{string indicating the type of confidence interval for \eqn{\eta}, one of \code{"wald"} or \code{"lrt"}}

\item{level}{the confidence level required (default to 0.95).}

\item{trunc}{logical indicating whether the estimates and confidence intervals should be truncated in \eqn{[0,1]}}

\item{margtrans}{marginal transformation; if \code{"none"}, data are assumed to be in uniform margins}

\item{ties.method}{string indicating the type of method for \code{rank}; see \code{\link[base]{rank}} for a list of options. Default to \code{"random"}}

\item{plot}{logical; should graphs be plotted?}

\item{...}{additional arguments passed to \code{plot}; current support for \code{main}, \code{xlab}, \code{ylab}, \code{add} and further \code{pch}, \code{lty}, \code{type}, \code{col} for points; additional arguments for confidence intervals are handled via \code{cipch}, \code{cilty}, \code{citype}, \code{cicol}.}
}
\value{
a named list with elements
\itemize{
\item \code{qlev}: a \code{K} vector of percentile levels
\item \code{eta}: a \code{K} by 3 matrix with point estimates, lower and upper confidence intervals
\item \code{chi}: a \code{K} by 3 matrix with point estimates, lower and upper confidence intervals
}
}
\description{
For data with unit Pareto margins, the coefficient of tail dependence \eqn{\eta} is defined  via \deqn{\Pr(\min(X) > x) = L(x)x^{-1/\eta},}
where \eqn{L(x)} is a slowly varying function. Ignoring the latter, several estimators of \eqn{\eta} can be defined. In unit Pareto margins, \eqn{\eta} is a nonnegative shape parameter that can be estimated by fitting a generalized Pareto distribution above a high threshold. In exponential margins, \eqn{\eta} is a scale parameter and the maximum likelihood estimator of the latter is the Hill estimator. Both methods are based on peaks-over-threshold and the user can choose between pointwise confidence obtained through a likelihood ratio test statistic (\code{"lrt"}) or the Wald statistic (\code{"wald"}).
}
\details{
The most common approach for estimation is the empirical survival copula, by evaluating the proportion of sample minima with uniform margins that exceed a given \eqn{x}. An alternative estimator uses a smoothed estimator of the survival copula using Bernstein polynomial, resulting in the so-called \code{betacop} estimator. Approximate pointwise confidence intervals for the latter are obtained by assuming the proportion of points is binomial.

The coefficient of tail correlation \eqn{\chi} is
\deqn{\chi = \lim_{u \to 1} \frac{\Pr(F_1(X_1)>u, \ldots, F_D(X_D)>u)}{1-u}.}
Asymptotically independent vectors have \eqn{\chi = 0}. The estimator uses an estimator of the survival copula
}
\note{
As of version 1.15, the percentiles used are from the minimum variable. This ensures that, regardless of the number of variables,
there is no error message returned because the quantile levels are too low for there to be observations
}
\examples{
\dontrun{
set.seed(765)
# Max-stable model
dat <- rmev(n = 1000, d = 4, param = 0.7, model = "log")
taildep(dat, confint = 'wald')
}
}
\seealso{
\code{\link[evd]{chiplot}} for bivariate empirical estimates of \eqn{\chi}{chi} and \eqn{\bar{\chi}}{chibar}.
}
