% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tem.R
\name{gevr}
\alias{gevr}
\title{Generalized extreme value distribution (return level parametrization)}
\arguments{
\item{par}{vector of \code{retlev}, \code{scale} and \code{shape}}

\item{dat}{sample vector}

\item{V}{vector calculated by \code{gevr.Vfun}}

\item{p}{probability, corresponding to \eqn{(1-p)}th quantile for \eqn{z}}
}
\description{
Likelihood, score function and information matrix, bias,
approximate ancillary statistics and sample space derivative
for the generalized extreme value distribution  parametrized in terms of the return level \eqn{z}, scale and shape.
}
\section{Usage}{
 \preformatted{gevr.ll(par, dat, p)
gevr.ll.optim(par, dat, p)
gevr.score(par, dat, p)
gevr.infomat(par, dat, p)
gevr.Vfun(par, dat, p)
gevr.phi(par, dat, p, V)
gevr.dphi(par, dat, p, V)}
}

\section{Functions}{

\itemize{
\item{\code{gevr.ll}:} {log-likelihood}
\item{\code{gevr.ll.optim}:} {negative log-likelihood parametrized in terms of return levels, \code{log(scale)} and shape in order to perform unconstrained optimization}
\item{\code{gevr.score}:} {score vector}
\item{\code{gevr.infomat}:} {observed information matrix}
\item{\code{gevr.Vfun}:} {vector implementing conditioning on approximate ancillary statistics for the TEM}
\item{\code{gevr.phi}:} {canonical parameter in the local exponential family approximation}
\item{\code{gevr.dphi}:} {derivative matrix of the canonical parameter in the local exponential family approximation}
}
}
\author{
Leo Belzile
}

