% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univdist.R
\name{gpd}
\alias{gpd}
\title{Generalized Pareto distribution}
\arguments{
\item{par}{vector of \code{scale} and \code{shape}}

\item{dat}{sample vector}

\item{tol}{numerical tolerance for the exponential model}

\item{method}{string indicating whether to use the expected  (\code{'exp'}) or the observed (\code{'obs'} - the default) information matrix.}

\item{V}{vector calculated by \code{gpd.Vfun}}

\item{n}{sample size}
}
\description{
Likelihood, score function and information matrix, bias,
approximate ancillary statistics and sample space derivative
for the generalized Pareto distribution
}
\section{Usage}{
 \preformatted{gpd.ll(par, dat, tol=1e-5)
gpd.ll.optim(par, dat, tol=1e-5)
gpd.score(par, dat)
gpd.infomat(par, dat, method = c('obs','exp'))
gpd.bias(par, n)
gpd.Fscore(par, dat, method = c('obs','exp'))
gpd.Vfun(par, dat)
gpd.phi(par, dat, V)
gpd.dphi(par, dat, V)}
}

\section{Functions}{


\itemize{
\item{\code{gpd.ll}:} {log likelihood}
\item{\code{gpd.ll.optim}:} {negative log likelihood parametrized in terms of \code{log(scale)} and shape
in order to perform unconstrained optimization}
\item{\code{gpd.score}:} {score vector}
\item{\code{gpd.infomat}:} {observed or expected information matrix}
\item{\code{gpd.bias}:} {Cox-Snell first order bias}
\item{\code{gpd.Fscore}:} {Firth's modified score equation}
\item{\code{gpd.Vfun}:} {vector implementing conditioning on approximate ancillary statistics for the TEM}
\item{\code{gpd.phi}:} {canonical parameter in the local exponential family approximation}
\item{\code{gpd.dphi}:} {derivative matrix of the canonical parameter in the local
exponential family approximation}
}
}

\references{
Firth, D. (1993). Bias reduction of maximum likelihood estimates, \emph{Biometrika}, \strong{80}(1), 27--38.

Coles, S. (2001). \emph{An Introduction to Statistical Modeling of Extreme Values}, Springer, 209 p.

Cox, D. R. and E. J. Snell (1968). A general definition of residuals, \emph{Journal of the Royal Statistical Society: Series B (Methodological)}, \strong{30}, 248--275.

Cordeiro, G. M. and R. Klein (1994). Bias correction in ARMA models, \emph{Statistics and Probability Letters}, \strong{19}(3), 169--176.

Giles, D. E., Feng, H. and R. T. Godwin (2016).  Bias-corrected maximum likelihood estimation of the  parameters of the generalized Pareto distribution, \emph{Communications in Statistics - Theory and Methods}, \strong{45}(8), 2465--2483.
}
\author{
Leo Belzile
}
