% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dutils.R
\name{dspline}
\alias{dspline}
\alias{dspline<-}
\title{Simple linear spline}
\usage{
dspline(data, y = NULL, x = NULL, breaks = 4, probs = NULL,
  equi = FALSE, regex = mets.options()$regex, sep = NULL, na.rm = TRUE,
  labels = NULL, all = FALSE, ...)
}
\arguments{
\item{data}{if x is formula or names for data frame then data frame is needed.}

\item{y}{name of variable, or fomula, or names of variables on data frame.}

\item{x}{name of variable, or fomula, or names of variables on data frame.}

\item{breaks}{number of breaks, for variables or vector of break points,}

\item{probs}{groups defined from quantiles}

\item{equi}{for equi-spaced breaks}

\item{regex}{for regular expressions.}

\item{sep}{seperator for naming of cut names.}

\item{na.rm}{to remove NA for grouping variables.}

\item{labels}{to use for cut groups}

\item{all}{to do all variables, even when breaks are not unique}

\item{...}{Optional additional arguments}
}
\description{
Constructs simple linear spline  on a data frame using the formula syntax of dutils
}
\examples{
data(TRACE)
TRACE <- dspline(TRACE,~wmi,breaks=c(1,1.3,1.7))
cca <- coxph(Surv(time,status==9)~age+vf+chf+wmi,data=TRACE)
cca2 <- coxph(Surv(time,status==9)~age+wmi+vf+chf+wmi.spline1+wmi.spline2+wmi.spline3,data=TRACE)
anova(cca,cca2)

nd=data.frame(age=50,vf=0,chf=0,wmi=seq(0.4,3,by=0.01))
nd <- dspline(nd,~wmi,breaks=c(1,1.3,1.7))
pl <- predict(cca2,newdata=nd)
plot(nd$wmi,pl,type="l")

}
\author{
Thomas Scheike
}
