% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof-phreg.R
\name{gof.phreg}
\alias{gof.phreg}
\title{GOF for Cox PH regression}
\usage{
\method{gof}{phreg}(object, n.sim = 1000, silent = 1, ...)
}
\arguments{
\item{object}{is phreg object}

\item{n.sim}{number of simulations for score processes}

\item{silent}{to show timing estimate will be produced for longer jobs}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Cumulative score process residuals for Cox PH regression
p-values based on Lin, Wei, Ying resampling.
}
\examples{
data(TRACE)

m1 <- phreg(Surv(time,status==9)~vf+chf+diabetes,data=TRACE) 
gg <- gof(m1)
par(mfrow=c(1,3))
plot(gg)

m1 <- phreg(Surv(time,status==9)~strata(vf)+chf+diabetes,data=TRACE) 
gg <- gof(m1)
}
\author{
THomas Scheike and Klaus K. Holst
}
