% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densi_diver.R
\name{densi_diver}
\alias{densi_diver}
\title{Density measures}
\usage{
densi_diver(dataset, store = FALSE, dec_c = ".", verbose = FALSE)
}
\arguments{
\item{dataset}{A data.frame obtained from \code{read_data}.}

\item{store}{A logical value indicating if the user want to store the results in a file.}

\item{dec_c}{A character used for decimal separator on results file.}

\item{verbose}{A logical value indicating indicating if progress messages should be given.}
}
\value{
This function returns a data.frame with all the calculated density measures:
\item{den_chir_dip}{Diptera Chironomidae density.}
\item{den_non_chir_dip}{Diptera no Chironomidae density.}
\item{den_ephe}{Ephemeroptera density.}
\item{den_molus}{Mollusca density.}
\item{den_gastr}{Gastropoda densityv.}
\item{den_biv}{Bivalvia density.}
\item{den_crus}{Crustacea density.}
\item{den_nais}{Naididae density.}
\item{den_lhoff}{\emph{Limnodrilus} hoffmeisteri density.}
\item{den_bothr}{\emph{Bothrioneurum} density.}
\item{den_tubi}{\emph{Tubifex} density.}
\item{den_dero}{\emph{Dero} density.}
\item{den_prist}{\emph{Pristina} density.}
\item{den_chiro}{\emph{Chironomus} density.}
\item{den_nais}{\emph{Nais} density.}
\item{den_hele}{\emph{Heleobia} density.}
\item{den_subchiro}{\emph{Chironominae} density.}
\item{den_suborth}{Orthocladiinae density.}
\item{den_subtany}{Tanypodinae density.}
\item{den_t}{Total density.}
\item{den_t_bothr}{\emph{Bothrioneurum}/Total density.}
\item{den_t_lhoff}{\emph{Limnodrilus hoffmeisteri}/Total density.}
\item{den_t_tubi}{\emph{Tubifex}/Total density.}
\item{den_t_dero}{\emph{Dero}/Total density.}
\item{den_t_prist}{\emph{Pristina}/Total density.}
\item{den_t_chiro}{\emph{Chironomus}/Total density.}
\item{den_oli}{Oligochaeta density.}
\item{den_tricho}{Trichoptera density.}
\item{den_ostr}{Ostracoda density.}
\item{den_amph}{Amphipoda density.}
\item{den_polym}{Polymitarcidae density.}
\item{den_hyal}{Hyalella density.}
\item{den_coch}{Cochliopidae density.}
\item{den_chironomidae}{Chironomidae density.}
}
\description{
Calculates density measures
}
\details{
Density is a universal measure used in all types of biological studies. Density is best classified with trophic measurements because it is an element of production; however, it is difficult to interpret because it requires careful quantification and is not monotonous in response (i.e., density can decrease or increase in response to contamination) (Barbour et al., 1996).
}
\examples{

#Example data is a properly formatted table with richness measures of two sites
example_data

#Run densi_diver with that example_data
dendiver<-densi_diver(example_data)

#Check results
dendiver
}
\references{
\itemize{
\item{Barbour MT, Gerritsen J, Griffith GE, Frydenborg R, McCarron E, White JS & Bastian ML (1996) \doi{10.2307/1467948>}}
}
}
\seealso{
\link[metrix]{read_data}
}
\author{
Juan Manuel Cabrera and Julieta Capeleti.
}
