% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{get_github_metrics}
\alias{get_github_metrics}
\title{Get the repository summary or time course metrics}
\usage{
get_github_metrics(
  repo,
  token = NULL,
  count = "all",
  data_format = "dataframe",
  time_course = FALSE
)
}
\arguments{
\item{repo}{The repository name. So for `https://github.com/fhdsl/metricminer`, it would be `fhdsl/metricminer`}

\item{token}{You can provide the Personal Access Token key directly or this function will attempt to grab a PAT that was stored using the `authorize("github")` function}

\item{count}{How many items would you like to receive? Put "all" to retrieve all records.}

\item{data_format}{Default is to return a curated data frame. However if you'd like to see the raw information returned from GitHub set format to "raw".}

\item{time_course}{Should the time course data be collected or only the summary metrics?}
}
\value{
Repository summary or time course metrics for a particular GitHub repository as a dataframe
}
\description{
This is a function to get the information about a repository
}
\examples{
\dontrun{

authorize("github")
metrics <- get_github_metrics(repo = "fhdsl/metricminer")

summary_metrics <- get_github_repo_summary(repo = "fhdsl/metricminer")
timecourse_metrics <- get_github_repo_timecourse(repo = "fhdsl/metricminer")
}
}
