% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_cv}
\alias{filter_cv}
\title{Filter Features based on their coefficient of variation}
\usage{
filter_cv(
  data,
  reference_samples,
  max_cv = 0.2,
  ref_as_group = FALSE,
  group_column = NULL,
  na_as_zero = TRUE
)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{reference_samples}{The names of the samples or group which will be used to calculate the CV of a feature. Usually Quality Control samples.}

\item{max_cv}{The maximum allowed CV. 0.2 is a reasonable start.}

\item{ref_as_group}{A logical indicating if \code{reference_samples} are the names of samples or group(s).}

\item{group_column}{Only relevant if \code{ref_as_group = TRUE}. Which column should be used for grouping reference and non-reference samples? Usually \code{group_column = Group}. Uses \code{\link[rlang]{args_data_masking}}.}

\item{na_as_zero}{Should \code{NA} be replaced with 0 prior to calculation?
Under the hood \code{filter_cv} calculates the CV by \code{stats::sd(..., na.rm = TRUE) / mean(..., na.rm = TRUE)}.
If there are 3 samples to calculate the CV from and 2 of them are \code{NA} for a specific feature, then the CV for that Feature will be \code{NA}
if \code{na_as_zero = FALSE}. This might lead to problems. \code{na_as_zero = TRUE} is the safer pick.
Zeros will be replaced with \code{NA} after calculation no matter if it is \code{TRUE} or \code{FALSE}.}
}
\value{
A filtered tibble.
}
\description{
Filters Features based on their coefficient of variation (CV).
The CV is defined as \eqn{CV = \frac{s_i}{\overline{x_i}}} with \eqn{s_i} = Standard deviation of sample \eqn{i} and \eqn{\overline{x_i}} = Mean of sample \eqn{i}.
}
\examples{
# Example 1: Define reference samples by sample names
toy_metaboscape \%>\%
  filter_cv(max_cv = 0.2, reference_samples = c("QC1", "QC2", "QC3"))

# Example 2: Define reference samples by group name
toy_metaboscape \%>\%
  join_metadata(toy_metaboscape_metadata) \%>\%
  filter_cv(max_cv = 0.2, reference_samples = "QC", ref_as_group = TRUE, group_column = Group)
}
\references{
\href{https://en.wikipedia.org/wiki/Coefficient_of_variation}{Coefficient of Variation on Wikipedia}
}
