% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimaandpaths.R
\name{oneminimum.fes}
\alias{oneminimum.fes}
\title{Creates one ad hoc free energy minimum for a fes object}
\usage{
\method{oneminimum}{fes}(inputfes, cv1, cv2, cv3)
}
\arguments{
\item{inputfes}{fes object.}

\item{cv1}{the value of collective variable 1.}

\item{cv2}{the value of collective variable 2.}
  
\item{cv3}{the value of collective variable 3.}
}
\value{
minima object.
}
\description{
`oneminimum.fes` creates an ad hoc free energy minimum on free energy surface.
This can be used to calculate free energy surface evolution at arbitrary
point of free energy surface.
}
\examples{
tfes<-fes(acealanme1d)
minima<-fesminima(tfes)
minima<-minima+oneminimum(tfes, cv1=0, cv2=0)
minima
}
