% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/option_parsers.R
\name{parse_seq_input}
\alias{parse_seq_input}
\title{Read sequences in an unknown format}
\usage{
parse_seq_input(input = NULL, file = NULL)
}
\arguments{
\item{input}{(\code{character}) One of the following: 
\describe{
  \item{A character vector of sequences}{See the example below for what this
  looks like. The parser \code{\link{read_fasta}} produces output like this.}
  \item{A list of character vectors}{Each vector should have one base per element.}
  \item{A "DNAbin" object}{This is the result of parsers like
  \code{\link[ape]{read.FASTA}}.}
  \item{A list of "SeqFastadna" objects}{This is the result of parsers like
  \code{\link[seqinr]{read.fasta}}.}
  Either "input" or "file" must be supplied but not both.
}}

\item{file}{The path to a FASTA file containing sequences to use. Either
"input" or "file" must be supplied but not both.}
}
\value{
A named character vector of sequences
}
\description{
Read sequences in an unknown format. This is meant to parse the sequence
input arguments of functions like \code{\link{primersearch}}.
}
\keyword{internal}
