% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/40_plot.R
\name{draw_spectrum}
\alias{draw_spectrum}
\title{Draw Spectrum}
\usage{
draw_spectrum(
  obj,
  foc_rgn = NULL,
  foc_frac = NULL,
  foc_only = TRUE,
  add = FALSE,
  fig_rgn = NULL,
  main = NULL,
  show = TRUE,
  show_d2 = FALSE,
  truepar = NULL,
  mar = c(4.1, 5.1, 0.1, 0.1),
  si_line = list(),
  sm_line = list(),
  sp_line = list(),
  d2_line = list(),
  lc_lines = list(),
  tp_lines = list(),
  cent_pts = list(),
  bord_pts = list(),
  norm_pts = list(),
  bg_rect = list(),
  foc_rect = list(),
  lc_rects = list(),
  tp_rects = list(),
  bt_axis = list(),
  lt_axis = list(),
  tp_axis = list(),
  rt_axis = list(),
  tp_verts = list(),
  lc_verts = list(),
  lgd = list()
)
}
\arguments{
\item{obj}{An object of type \code{spectrum} or \code{decon2}. For details see
\link{metabodecon_classes}.}

\item{foc_rgn}{Numeric vector specifying the start and end of focus region in ppm.}

\item{foc_frac}{Numeric vector specifying the start and end of focus region as fraction of
the full spectrum width.}

\item{foc_only}{Logical. If TRUE, only the focused region is drawn. If FALSE, the full
spectrum is drawn.}

\item{add}{If TRUE, draw into the currently open figure. If FALSE, start a new figure.}

\item{fig_rgn}{Drawing region in normalized device coordinates as vector of the form \code{c(x1, x2, y1, y2)}.}

\item{main}{Main title of the plot. Drawn via \code{\link[=title]{title()}}.}

\item{show}{Logical. If FALSE, the function returns without doing anything.}

\item{show_d2}{Logical. If TRUE, the second derivative of the spectrum is drawn. Setting
this to TRUE changes most of the defaults for the drawing, e.g. by disabling
the drawing of anything related to signal intensities and by changing the
y-axis label to "Second Derivative".}

\item{truepar}{Data frame with columns x0, A and lambda containing the true lorentzian that
were used to simulate the spectrum. Required if any \verb{tp_*} argument is set.}

\item{mar}{Number of lines below/left-of/above/right-of plot region.}

\item{si_line, sm_line, lc_lines, sp_line, d2_line, tp_lines}{List  of  parameters  passed  to  \code{\link[=lines]{lines()}}  when  drawing  the  raw signal
intensities, smoothed signal intensities, lorentzian curves found by
deconvolution, superposition of lorentzian curves, second derivative and/or
true lorentzian curves.}

\item{cent_pts, bord_pts, norm_pts}{List of parameters passed to \code{\link[=points]{points()}} when drawing the peak center  points,
peak border points and non-peak points.}

\item{bg_rect, lc_rects, foc_rect, tp_rects}{List of parameters passed to \code{\link[=rect]{rect()}} when drawing the background, lorentzian
curve substitutes, focus rectangle and/or true lorentzian curve substitutes.}

\item{bt_axis, lt_axis, tp_axis, rt_axis}{List of parameters used to overwrite the default values  passed  to  \code{\link[=axis]{axis()}}
when drawing the bottom, left,  top  and  right  axis.  In  addition  to  the
parameters of \code{\link[=axis]{axis()}}, the following additional parameters are supported  as
well:
\itemize{
\item \code{text}:   Description for the axis. Drawn via \code{\link[=mtext]{mtext()}}.
\item \code{n}:      Number of tickmarks.
\item \code{digits}: Number of digits for rounding the labels. If a vector of numbers
is provided, all numbers are tried, until \code{n} unique labels are
found. See 'Details'.
\item \code{sf}:     Scaling factor. Axis values are divided by this number before the
labels are calculated. If you set this to anything unequal 1, you
should also choose \code{text} in a way that reflects the scaling.
E.g. if you set \code{sf = 1e6} you could change the text from
\code{"Signal Intensity [au]"} to \code{"Signal Intensity [Mau]"} or
\code{"Signal Intensity [au] / 1e6"}, with \code{"Mau"} meaning
"Mega-Arbitrary-Units".
}}

\item{lc_verts, tp_verts}{List of parameters passed to \code{\link[=abline]{abline()}} when drawing vertical lines at the
centers of estimated lorentzian curves and/or true lorentzian curves. Setting
tp_verts$show to TRUE requires \code{truepar} to be set.}

\item{lgd}{List of parameters passed to \code{\link[=legend]{legend()}} when drawing the legend.}
}
\value{
NULL. Called for side effect of plotting.
}
\description{
Draws a single spectrum.  Internally  used  by  \code{\link[=plot_spectrum]{plot_spectrum()}},  which  is
usually  the  recommended  way  to  plot  spectra.  For  usage  examples  see
\href{https://github.com/spang-lab/metabodecon/blob/main/tests/testthat/test-draw_spectrum.R}{test/testthat/test-draw_spectrum.R}.
}
\details{
Parameters \code{bt_axis}, \code{lt_axis}, \code{tp_axis} and \code{rt_axis} all  support  option
\code{n} and \code{digits}, where \code{n = 5} means "Draw 5 tickmarks over  the  full  axis
range" and \code{digits = 3} means "round the label shown beside each tickmark  to
3 digits". If \code{n} is omitted, a suitable value is chosen automatically using
\code{\link[=axTicks]{axTicks()}}. If \code{digits} is omitted, a default of \code{2:12} is used. Providing a
vector of \code{digits} causes each digit to be tried as argument  for  \code{\link[=round]{round()}},
until a digit is encountered that results in \code{n} unique labels. Example:

Assume we have \code{n = 4} and the corresponding  calculated  tickmark  positions
are: 1.02421, 1.02542, 1.02663 and 1.02784. If we provide \code{digits = 1:5}, the
following roundings are tried:\tabular{lllll}{
   digit \tab label 1 \tab label 2 \tab label 3 \tab label 4 \cr
   1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   2 \tab 1.02 \tab 1.03 \tab 1.03 \tab 1.03 \cr
   3 \tab 1.024 \tab 1.025 \tab 1.027 \tab 1.028 \cr
   4 \tab 1.0242 \tab 1.0254 \tab 1.0266 \tab 1.0278 \cr
   5 \tab 1.02421 \tab 1.02542 \tab 1.02663 \tab 1.02784 \cr
}


In the above example the process would stop at \code{digit = 3}, because  at  this
point we have n = 4 unique labels (1.024, 1.025, 1.027 and 1.028).
}
\examples{
decon <- deconvolute(sim[[1]], sfr = c(3.55, 3.35))
draw_spectrum(obj = decon)
draw_spectrum(obj = decon, lgd = list(x = "top", bg = NA))
draw_spectrum(obj = decon, foc_rgn = c(3.45, 3.37))
draw_spectrum(obj = decon, fig = c(0.1, 0.4, 0.30, 0.45), add = TRUE)
draw_spectrum(obj = decon, fig = c(0.1, 0.4, 0.05, 0.20), add = FALSE)
draw_spectrum(obj = decon, lc_lines = NULL, lc_rects = NULL, foc_only = FALSE)
}
