% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGEtest.R
\name{metaGE.test}
\alias{metaGE.test}
\title{Meta-analysis test for Genotype x Environment interactions: Contrast or Regression.}
\usage{
metaGE.test(
  Data,
  MatCorr,
  Incidence = NULL,
  Contrast = NULL,
  Covariate = NULL,
  EnvName = NULL,
  NA.omit = TRUE,
  DropZScores = FALSE
)
}
\arguments{
\item{Data}{A dataset containing the estimated marker effect and its associated pvalue of each marker (in rows) in each environment (in columns), as obtained from \code{\link[=metaGE.collect]{metaGE.collect()}}.}

\item{MatCorr}{The inter-environment correlation matrix. It can be compute by the \code{\link[=metaGE.cor]{metaGE.cor()}} function.}

\item{Incidence}{A matrix of incidence, as obtained from \code{\link[=metaGE.incidence]{metaGE.incidence()}} or a list of such matrix.}

\item{Contrast}{A matrix of contrast, or a list of such matrix.}

\item{Covariate}{A dataset containing the values of one or more covariates (in columns) in each environment (in rows).}

\item{EnvName}{The name of the column containing the names of the environment in the \code{Covariate} dataset.}

\item{NA.omit}{A boolean specifying whether the markers with some \code{NA} values should be removed from the test procedure. (\code{TRUE} by default)}

\item{DropZScores}{A boolean specifying whether the Zscores should be dropped from the dataset or not. (\code{FALSE} by default)}
}
\value{
The dataset \code{Data} with supplementary columns containing the PVALUE of each test performed.
}
\description{
The function metaGE.test compute meta-analysis contrast or regression test.
}
\details{
If \code{Incidence} is provided, the function will perform all the corresponding tests of contrast. If \code{Covariate} is provided, the function will perform all the corresponding meta-regression tests.
The \code{Contrast} can be \code{NULL}, in this case the identity matrix is used.
}
\examples{
require(dplyr)

 # Import the data
data("metaData")
data("envDesc")

#' # Compute the inter-environment correlation matrix
matCorr <- metaGE.cor(metaData, Threshold = 0.8)

#### Contrast test
# Build the matrix of incidence
Incidence.Water <- metaGE.incidence(VarName = "Water",Covariate = envDesc,
                                    EnvName = "ShortName", Data = metaData)

# Perform the contrast test
ContrastDF <- metaGE.test(metaData, matCorr,Incidence = Incidence.Water, Contrast = NULL)
head(ContrastDF \%>\% select(CHR, POS, MARKER, PVALUE.Contrast1))

#### Regression test
RegressionDF <- metaGE.test(metaData,matCorr, Covariate = envDesc[,c(1,5)],EnvName = "ShortName" )
head(RegressionDF \%>\% select(CHR, POS, MARKER, PVALUE.Tnight.mean))
}
