% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_random.R
\name{meta_random}
\alias{meta_random}
\title{Bayesian Random-Effects Meta-Analysis}
\usage{
meta_random(y, SE, labels, d = "norm", d.par = c(0, 0.3),
  tau = "halfcauchy", tau.par = 0.5, sample = 10000,
  summarize = "integrate", ...)
}
\arguments{
\item{y}{mean in each study}

\item{SE}{standard error in each study}

\item{labels}{optional: character values with study labels}

\item{d}{type of prior for mean effect \eqn{d} (see \code{\link{prior}})}

\item{d.par}{prior parameters for \eqn{d}}

\item{tau}{type of prior for standard deviation of study effects \eqn{\tau} in random-effects meta-analysis (i.e., the SD of d across studies; see \code{\link{prior}})}

\item{tau.par}{prior parameters for \eqn{\tau}}

\item{sample}{number of samples in JAGS after burn-in and thinning (see \code{\link[runjags]{run.jags}}). Samples are used to get posterior  estimates for each study effect (which will show shrinkage). Only works for priors defined in \code{\link{prior}}.}

\item{summarize}{whether and to compute parameter summaries (mean, median, SD, 95\% quantile interval, HPD interval). If \code{summarize = "integrate"}, numerical integration is used  (which is precise but can require some seconds of computing time), \code{summarize = "jags"} summarizes the JAGS samples, and \code{summarize = "none"} suppresses parameter summaries.}

\item{...}{arguments passed to \link[runjags]{run.jags} (e.g., MCMC parameters such as \code{sample}, \code{burnin}, \code{n.chains}, \code{thin} or \code{method="parallel"})}
}
\description{
Runs a Bayesian meta-analysis assuming that the effect size \eqn{d} varies across studies with standard deviation \eqn{\tau} (i.e., a random-effects analysis).
}
\examples{
\dontrun{
data(towels)
### Bayesian Random-Effects Meta-Analysis
mr <- meta_random(towels$logOR, towels$SE, towels$study,
                  d = "norm", d.par = c(0,.3), sample = 5000,
                  tau = "halfcauchy", tau.par = .5)
mr
plot_posterior(mr)
plot_forest(mr)
}
}
