% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JAMAlabels.R
\name{JAMAlabels}
\alias{JAMAlabels}
\title{Create study labels in JAMA layout (deprecated function)}
\usage{
JAMAlabels(author, year, citation, data = NULL)
}
\arguments{
\item{author}{A vector providing study authors.}

\item{year}{A vector providing year of publication.}

\item{citation}{A vector providing citation numbers.}

\item{data}{An optional data frame containing the study
information.}
}
\description{
Deprecated function to create study labels in JAMA layout (for
forest plot). Replaced by \code{\link{labels.meta}}.
}
\details{
This auxiliary function can be used to create study labels in JAMA
layout which can be added to a forest plot using argument
'studlab'.
}
\examples{
data(Fleiss1993bin)

refs <- 20 + 1:7

Fleiss1993bin$mylabs <-
  JAMAlabels(study, year, refs, data = Fleiss1993bin)

m <- metabin(d.asp, n.asp, d.plac, n.plac, data = Fleiss1993bin,
  studlab = paste(study, year),
  sm = "OR", random = FALSE)

forest(m, studlab = mylabs, layout = "JAMA",
  fontfamily = "Times", fontsize = 10)

}
\seealso{
\code{\link{labels.meta}}, \code{\link{forest.meta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
