% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siteFinder.R
\name{siteFinder}
\alias{siteFinder}
\title{siteFinder}
\usage{
siteFinder(NEON.site = NULL, Lat = NULL, Lon = NULL, radius = 150,
  networks = "all", startDate = NULL, endDate = NULL, vars = "all",
  elevThresh = NULL)
}
\arguments{
\item{NEON.site}{Mandatory if \code{Lat} and \code{Lon} are NULL; An object of class character containing a 4-letter NEON site Identifier. The lat/lon pair of the NEON.site will be used as your point of interest (POI).}

\item{Lat}{Mandatory if \code{NEON.site} is NULL; An object of numeric containing the latitude of your POI.}

\item{Lon}{Mandatory if \code{NEON.site} is NULL; An object of numeric containing the longitude of your POI.}

\item{radius}{An object of class numeric in kilometers (km) which describes the radius from your point of interest that will be searched for sites. Defaults to: 100 (km)}

\item{networks}{A vector of class character containing the network names; Defaults to 'all' networks.  Current networks are:\cr
\cr
COOP - Cooperative Observer Network [http://www.nws.noaa.gov/om/coop/],[http://www.nws.noaa.gov/om/coop/standard.htm]\cr
\cr
USCRN - United States Climate Reference Network [https://www.ncdc.noaa.gov/crn/] \cr
\cr
USRCRN - United States Regional Climate Reference Network; includes Southwest US regional network and Alabama regional network [https://www.ncdc.noaa.gov/crn/usrcrn/] \cr
\cr
ASOS - Automated Surface Observing System [https://www.ncdc.noaa.gov/data-access/land-based-station-data/land-based-datasets/automated-surface-observing-system-asos]\cr
\cr
AWOS - Automated Weather Observing System [https://www.ncdc.noaa.gov/data-access/land-based-station-data/land-based-datasets/automated-weather-observing-system-awos]\cr
\cr
SNOTEL - SNOw TELometry [http://www.wcc.nrcs.usda.gov/snow/]\cr
\cr
SCAN - Soil Climate Analysis Network [http://www.wcc.nrcs.usda.gov/scan/]\cr
\cr
NEON - National Ecological Observatory Network [http://www.neonscience.org/]\cr
\cr
Currently there are 13,368 available stations comprised within all above networks.  Some stations are part of various networks.  For instance some ASOS stations are also part of the COOP network.  We are in the process of adding more networks to the database.}

\item{startDate}{An object of class character containing the start date: 'YYYY-mm-dd'. Defaults to NULL}

\item{endDate}{An object of class character containing the end date: 'YYYY-mm-dd'. Defaults to NULL}

\item{vars}{A vector of class character containing search variables. Defaults to 'all.'  The network(s) that measure the specified variable(s) will be returned. The \code{vars} were generated on a network by network basis, assuming each station within said network collects the basic suite of measurements specified by the network.  For more information regarding measurement types by network, please see the links above. Users can search for individual variables using the \code{vars} command with one or many of the following variables:\cr
\cr
AIR_TEMP - Air temperature \cr
\cr
ALT - Altimeter Setting\cr
\cr
DEW_TEMP - Dewpoint Temperature \cr
\cr
PRECIP_BULK - Bulk Precipitation \cr
\cr
PRECIP_TYPE - Precipitation Type \cr
\cr
PRES - Barometric Pressure \cr
\cr
RH - Relative Humidity\cr
\cr
SFC_TEMP - Surface Temperature \cr
\cr
SKY - Sky Conditions \cr
\cr
SNOW_DEPTH - Snow Depth\cr
\cr
SNOW_WC - Snow Water Content\cr
\cr
SOIL_MOIS - Soil Moisture\cr
\cr
SOIL_TEMP - Soil Temperature\cr
\cr
SOL_RAD - Solar Radiation\cr
\cr
TSTORM - Thunderstorm Detection\cr
\cr
VIS - Visibility\cr
\cr
WET - Wetness\cr
\cr
WIND_DIR - Wind Direction\cr
\cr
WIND_SPE - Wind Speed\cr}

\item{elevThresh}{An object of class numeric in meters (m) which defines the elevation threshold to filter resulting sites.  This threshold is relative to your POI.  For instance, if \code{elevThresh} is set to '1000', any sites with elevations less than or equal to 1000 m relative to the POI will be returned. \cr}
}
\value{
object A list containing a vector comprising the latitude and longitude of center of search area, and a dataframe of environmental monitoring sites that meet the search criteria. \cr
}
\description{
A search tool that finds environmental monitoring sites from various networks (US only): COOP, USCRN, USRCRN, ASOS, AWOS, SNOTEL, SCAN, and NEON.
}
\examples{
siteFinder(NEON.site="HARV",startDate="1965-10-20",endDate="1986-09-02")
siteFinder(Lat=40.05,Lon=-105.27,startDate="2000-01-05",radius=45,network="COOP")
}
\seealso{
Currently none
}
\author{
Josh Roberti \email{jaroberti87@gmail.com} \cr
Cody Flagg \cr
Lee Stanish \cr
Sam Weintraub \cr
Derek Smith
}
\keyword{atmopsheric}
\keyword{atmosphere,}
\keyword{climate,}
\keyword{data,}
\keyword{environment,}
\keyword{environmental}
\keyword{in-situ}

