% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_contract.R
\name{convert_contract}
\alias{convert_contract}
\alias{contract}
\title{Contract lists of dates into messy dates}
\usage{
contract(x, collapse = TRUE)
}
\arguments{
\item{x}{A list of dates}

\item{collapse}{Do you want ranges to be collapsed?
TRUE by default.
If FALSE ranges are returned in compact format.}
}
\value{
A \code{mdate} vector
}
\description{
This function operates as the opposite of \code{expand()}.
It contracts a list of dates into the abbreviated annotation
of messy dates.
}
\details{
The ´contract()´ function first \code{expand()} 'mdate' objects
to then display their most succinct representation.
}
\examples{
d <- as_messydate(c("2001-01-01", "2001-01", "2001",
"2001-01-01..2001-02-02", "{2001-10-01,2001-10-04}",
"{2001-01,2001-02-02}", "28 BC", "-2000-01-01",
"{2001-01-01, 2001-01-02, 2001-01-03}"))
dplyr::tibble(d, contract(d))
}
