#' Find Mesonet variable definition
#'
#' @description
#'
#' Provide definition of a requested set of Mesonet variables including (by
#'  default) the standard variable identifier (ID), name, unit, and description.
#'
#' @param id a string or \link[base]{regular expression} to use for retrieving definitions
#'   of Mesonet variables
#'
#' @param columns a character vector of columns to include in the
#'  output. Possible values include any combination of "ID", "Variable Name",
#'  "Unit" or "Description"
#'
#' @returns a data frame with Mesonet variable definitions filtered by the \code{id}
#'  argument
#'
#' @examples
#'
#' mnet_variable_definition("RAIN")
#'
#' mnet_variable_definition("^2")
#'
#' mnet_variable_definition("^2",
#'                          columns = c("ID", "Variable Name", "Unit"))
#'
#' @export
#'
mnet_variable_definition <- function(id,
                                     columns = c("ID", "Variable Name", "Unit",
                                                 "Description")){
  # variable_definitions is a package-internal data structure
  variable_definitions |>
    with({
      variable_definitions[grep(id, ID), columns]
    })
}
