% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendPrompt.R
\name{sendPrompt}
\alias{sendPrompt}
\title{Send a prompt to a specified language model agent and return the response.}
\usage{
sendPrompt(
  agent,
  prompt,
  context = rbionfoExp,
  return.type = c("text", "object"),
  ...
)
}
\arguments{
\item{agent}{An object containing the agent's information (e.g., type and model etc.).}

\item{prompt}{The prompt text to send to the language model.}

\item{context}{Optional context to provide alongside the prompt (default is rbionfoExp).}

\item{return.type}{The type of output to return, either the text response ("text") or the entire response object ("object").}

\item{...}{Additional arguments to be passed to the prompt function.}
}
\value{
The text response or the entire response object, based on the specified return type.
}
\description{
Send a prompt to a specified language model agent and return the response.
}
\examples{
\dontrun{
agent <- setupAgent(name="openai",type="chat",model="gpt-4",
                    ai_api_key=Sys.getenv("OPENAI_API_KEY"))
prompt <- "tell me a joke"
response <- sendPrompt(agent, prompt)

response <- sendPrompt(agent,prompt,context=rbionfoExp,return.type="text", max_tokens = 500)
}
}
\seealso{
\code{\link{promptContext}} for predefined contexts to use.
}
