% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memoiR.R
\name{build_readme}
\alias{build_readme}
\title{Build README}
\usage{
build_readme(PDF = TRUE)
}
\arguments{
\item{PDF}{if \code{TRUE} (by default), a link to the PDF output is added.}
}
\value{
The content of the \code{README.md} file as a vector of characters, invisibly. Each element is a line of the file.
}
\description{
Build a \code{README.md} file that will be used as index of GitHub Pages.
}
\details{
R Markdown files of the project are used to get the title and abstract of the published documents.
Run this function once in each project created from a memoiR template, before \code{\link[=build_githubpages]{build_githubpages()}}.
A link to their HTML and, optionally, PDF versions is added.
Metadata fields are read in the .Rmd files YAML header: title, abstract and \code{URL}.
}
\examples{
## Simulate the creation of a new project
# Save working directory
original_wd <- getwd()
# Get a temporary working directory
wd <- tempfile("example")
# Simulate File > New File > R Markdown... > From Template > Simple Article
rmarkdown::draft(wd, template="simple_article", package="memoiR", edit=FALSE)
# Go to temp directory
setwd(wd)
# Make it the current project
usethis::proj_set(path = ".", force = TRUE)

# Build README.md file
build_readme()
# Content
readLines("README.md")

## End of the example: cleanup
# Return to the original working directory and clean up
setwd(original_wd)
unlink(wd, recursive=TRUE)

}
