# The Moving Epidemic Method R Package

## Overview

This is the R package of the Moving Epidemic Method

## Installation

To install the lastest stable version from the official R repositories (*CRAN*):

```
# install the mem CRAN version
install.packages("mem")
```

To install the lastest development version of *mem*.


```
# in case you dont have devtools installed, install it
install.packages(devtools)

# install the new package from github
devtools::install_github("lozalojo/mem")
```

## Usage

```
# load the library
library("mem")

# run the help
help("mem")
```

## References

Vega T, Lozano JE, Ortiz de Lejarazu R, Gutierrez Perez M. Modelling influenza epidemic—can we detect the beginning and predict the intensity and duration? Int Congr Ser. 2004 Jun;1263:281–3. 

Vega T, Lozano JE, Meerhoff T, Snacken R, Mott J, Ortiz de Lejarazu R, et al. Influenza surveillance in Europe: establishing epidemic thresholds by the moving epidemic method. Influenza Other Respir Viruses. 2013 Jul;7(4):546–58. DOI:10.1111/j.1750-2659.2012.00422.x.

Vega T, Lozano JE, Meerhoff T, Snacken R, Beaute J, Jorgensen P, et al. Influenza surveillance in Europe: comparing intensity levels calculated using the moving epidemic method. Influenza Other Respir Viruses. 2015 Sep;9(5):234–46. DOI:10.1111/irv.12330.

Lozano JE. lozalojo/mem: Second release of the MEM R library. Zenodo [Internet]. [cited 2017 Feb 1]; Available from: https://zenodo.org/record/165983. DOI:10.5281/zenodo.165983
