% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hydrology_infiltration}
\alias{hydrology_infiltration}
\alias{hydrology_infiltrationBoughton}
\alias{hydrology_infiltrationGreenAmpt}
\alias{hydrology_infiltrationRepartition}
\alias{hydrology_infiltrationAmount}
\title{Soil infiltration}
\usage{
hydrology_infiltrationBoughton(input, Ssoil)

hydrology_infiltrationGreenAmpt(t, psi_w, Ksat, theta_sat, theta_dry)

hydrology_infiltrationRepartition(I, widths, macro, a = -0.005, b = 3)

hydrology_infiltrationAmount(
  rainfallInput,
  rainfallIntensity,
  soil,
  soilFunctions,
  model = "GreenAmpt1911",
  K_correction = 1
)
}
\arguments{
\item{input}{A numeric vector of (daily) water input (in mm of water).}

\item{Ssoil}{Soil water storage capacity (can be referred to topsoil) (in mm of water).}

\item{t}{Time of the infiltration event}

\item{psi_w}{Matric potential at the wetting front}

\item{Ksat}{hydraulic conductivity at saturation}

\item{theta_sat}{volumetric content at saturation}

\item{theta_dry}{volumetric content at the dry side of the wetting front}

\item{I}{Soil infiltration (in mm of water).}

\item{widths}{Width of soil layers (in mm).}

\item{macro}{Macroporosity of soil layers (in \%).}

\item{a, b}{Parameters of the extinction function used for water infiltration.}

\item{rainfallInput}{Water from the rainfall event reaching the soil surface (mm)}

\item{rainfallIntensity}{rainfall intensity rate (mm/h)}

\item{soil}{A list containing the description of the soil (see \code{\link{soil}}).}

\item{soilFunctions}{Soil water retention curve and conductivity functions, either 'SX' (for Saxton) or 'VG' (for Van Genuchten).}

\item{model}{Infiltration model, either "GreenAmpt1911" or "Boughton1989"}

\item{K_correction}{Correction for saturated conductivity, to account for increased infiltration due to macropore presence}
}
\value{
Functions \code{hydrology_infiltrationBoughton}, \code{hydrology_infiltrationGreenAmpt} and \code{hydrology_infiltrationAmount} 
return the daily amount of water that infiltrates into the soil (in mm of water). 

Function \code{hydrology_infiltrationRepartition} returns the amount of infiltrated water that reaches each soil layer.
}
\description{
Soil infiltration functions:
\itemize{
  \item{Function \code{hydrology_infiltrationBoughton} calculates the amount of water that infiltrates into the topsoil, according to the USDA SCS curve number method (Boughton 1989).}
  \item{Function \code{hydrology_infiltrationGreenAmpt} calculates the amount of water that infiltrates into the topsoil, according to the model by Green & Ampt (1911).}
  \item{Function \code{hydrology_infiltrationAmount} uses either Green & Ampt (1911) or Boughton (1989) to estimate infiltration.}
  \item{Function \code{hydrology_infiltrationRepartition} distributes infiltration among soil layers depending on macroporosity.}
}
}
\details{
When using function \code{hydrology_infiltrationGreenAmpt}, the units of \code{Ksat}, \code{t} and \code{psi_wat} have to be in the same system (e.g. cm/h, h and cm).
}
\references{
Boughton (1989). A review of the USDA SCS curve number method. - Australian Journal of Soil Research 27: 511-523.

Green, W.H. and Ampt, G.A. (1911) Studies on Soil Physics, 1: The Flow of Air and Water through Soils. The Journal of Agricultural Science, 4, 1-24.
}
\seealso{
\code{\link{spwb}}, \code{\link{hydrology_waterInputs}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
\keyword{internal}
