% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_mergeTrees.R
\name{forest_simplification}
\alias{forest_simplification}
\alias{forest_mergeTrees}
\alias{forest_mergeShrubs}
\alias{forest_reduceToDominant}
\title{Forest complexity reduction}
\usage{
forest_mergeTrees(x, byDBHclass = TRUE, keepCohortsWithObsID = FALSE)

forest_mergeShrubs(x, byHeightclass = TRUE, keepCohortsWithObsID = FALSE)

forest_reduceToDominant(x, SpParams)
}
\arguments{
\item{x}{An object of class \code{\link{forest}}.}

\item{byDBHclass}{Logical flag to indicate that 5-cm tree DBH classes should be kept separated.}

\item{keepCohortsWithObsID}{Logical flag to indicate that cohorts with non-missin ObsID should be spared from merging.}

\item{byHeightclass}{Boolean flag to indicate that 10-cm shrub height classes should be kept separated.}

\item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsDefinition}} and \code{\link{SpParamsMED}}).}
}
\value{
Another \code{\link{forest}} object with simplified structure/composition, depending on the function.
}
\description{
Functions \code{forest_mergeTrees} and \code{forest_mergeShrubs} merge cohorts of a \code{\link{forest}} object. 
Function \code{forest_reduceToDominant} performs a strongest simplification of plant cohorts (see details).
}
\details{
Tree DBH classes are defined in 5-cm intervals, whereas shrub height classes are defined in 10-cm intervals.
Tree DBH and shrub height classes are defined up to a specific size (i.e. larger plants are not merged) 
corresponding to 52.5 cm and 90 cm, respectively.

Function \code{forest_reduceToDominant} simplifies the input forest to the tree cohort of highest LAI, among those of the tree species with highest LAI.
The leaf area index of the whole tree layer will be attributed to the chosen cohort. The same is performed for the shrub layer.
}
\examples{
# Example forest data
data("exampleforest")

# Reduce to dominant tree and dominant shrub
reduced <- forest_reduceToDominant(exampleforest, SpParamsMED)

# Check that overall LAI does not change
stand_LAI(exampleforest, SpParamsMED)
stand_LAI(reduced, SpParamsMED)
}
\seealso{
\code{\link{spwb}}, \code{\link{forest}},  \code{\link{forest_mapWoodyTables}}, \code{\link{fordyn}}, \code{\link{summary.forest}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
