% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/hydrology_interception.R
\name{hydrology_rainfallIntensity}
\alias{hydrology_rainfallIntensity}
\alias{hydrology_interception}
\alias{hydrology_rainInterception}
\alias{hydrology_interceptionPlot}
\title{Rainfall interception}
\usage{
hydrology_rainfallIntensity(month, prec, rainfallIntensityPerMonth)

hydrology_rainInterception(Rainfall, Cm, p, ER = 0.05, model = "Gash1995")

hydrology_interceptionPlot(
  x,
  SpParams,
  ER = 0.05,
  gdd = NA,
  throughfall = FALSE,
  model = "Gash1995"
)
}
\arguments{
\item{month}{Month of the year (from 1 to 12).}

\item{prec}{Precipitation for a given day (mm).}

\item{rainfallIntensityPerMonth}{A vector with twelve positions with average intensity of rainfall (in mm/h) for each month.}

\item{Rainfall}{A numeric vector of (daily) rainfall.}

\item{Cm}{Canopy water storage capacity.}

\item{p}{Proportion of throughfall (normally 1 - c, where c is the canopy cover).}

\item{ER}{The ratio of evaporation rate to rainfall rate.}

\item{model}{Rainfall interception model (either \code{"Gash1995"} or \code{"Liu2001"}).}

\item{x}{An object of class \code{\link{spwbInput}}.}

\item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}} and \code{\link{SpParamsMED}}).}

\item{gdd}{Growth degree days (in Celsius).}

\item{throughfall}{Boolean flag to plot relative throughfall instead of percentage of intercepted rainfall.}
}
\value{
Function \code{hydrology_rainInterception} returns a vector of the same length as \code{Rainfall} containing intercepted rain values. 

Function \code{hydrology_rainfallIntensity} returns a scalar with the rainfall intensity.
}
\description{
Function \code{hydrology_rainInterception} calculates the amount of rainfall intercepted daily by the canopy, given a rainfall and canopy characteristics. 
Two canopy interception models are currently available: the sparse Gash (1995) model and the Liu (2001) model. 
In both cases the current implementation assumes no trunk interception.
}
\details{
Function \code{hydrology_rainInterception} can accept either vectors or scalars as parameters \code{Cm}, \code{p} and \code{ER}. If they are supplied as vectors they should be of the same length as \code{Rainfall}.

Function \code{hydrology_rainfallIntensity} estimates the rainfall intensity (mm/h) for input values of rainfall and seasonal variation in rainfall intensity (mm/h).
}
\examples{
#Load example plot plant data
data(exampleforest)

#Default species parameterization
data(SpParamsMED)

#Draw rainfall interception for two values of the E/R ratio
hydrology_interceptionPlot(exampleforest, SpParamsMED, ER = c(0.05, 0.2))

}
\references{
Liu (2001). Evaluation of the Liu model for predicting rainfall interception in forests world-wide. - Hydrol. Process. 15: 2341-2360.

Gash (1979). An analytical model of rainfall interception by forests. - Quarterly Journal of the Royal Meteorological Society.                                       

Gash et al. (1995). Estimating sparse forest rainfall interception with an analytical model. - Journal of Hydrology.
}
\seealso{
\code{\link{spwb}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
