hydraulics.vulnerabilityCurvePlot<-function(x, soil = NULL, type="leaf",  psiVec =  seq(-0.1, -8.0, by =-0.01), 
                                            relative = FALSE,
                                            draw = TRUE) {
  
  TYPES = c("leaf","stem","root","rhizosphere")
  type = match.arg(type,TYPES)  
  
  cohortnames = row.names(x$cohorts)
  VCroot_kmax = x$below$VCroot_kmax
  VGrhizo_kmax = x$below$VGrhizo_kmax
  nlayer = ncol(VCroot_kmax)
  col = rainbow(nlayer, start = 0.8, end = 0.1)
  
  VCroot_c = x$paramsTransp$VCroot_c
  VCroot_d = x$paramsTransp$VCroot_d
  VCstem_kmax = x$paramsTransp$VCstem_kmax
  VCstem_c = x$paramsTransp$VCstem_c
  VCstem_d = x$paramsTransp$VCstem_d
  VCleaf_kmax = x$paramsTransp$VCleaf_kmax
  VCleaf_c = x$paramsTransp$VCleaf_c
  VCleaf_d = x$paramsTransp$VCleaf_d
  ncoh = nrow(x$above)

  if(relative) {
    VCstem_kmax = rep(1, ncoh)
    VCleaf_kmax = rep(1, ncoh)
    VCroot_kmax[] = 1
    VGrhizo_kmax[] = 1
  }
  res = NULL
  minPsi = min(psiVec)
  if(type=="leaf") {
    res = matrix(0, ncol=ncoh, nrow = length(psiVec))
    rownames(res) = psiVec
    colnames(res) = cohortnames
    
    for(i in 1:ncoh) {
      kleaf = unlist(lapply(psiVec, hydraulics.xylemConductance, VCleaf_kmax[i], VCleaf_c[i], VCleaf_d[i]))
      res[,i] = kleaf
      if(draw) {
        if(i==1) {
          plot(-psiVec, kleaf, type="l", xlim=c(0,-minPsi), ylim =c(0, max(VCleaf_kmax)),
               xlab = "Leaf pressure (-MPa)", ylab = expression(paste("Leaf conductance  ", (mmol*H[2]*O%.%s^{-1}%.%m^{-2}%.%MPa^{-1}))), col=i)
        } else {
          lines(-psiVec, kleaf, lty=i, col=i)
        }
      }
    }
    if(draw) legend("topright", legend = cohortnames, lty=1:ncoh, col = 1:ncoh, bty="n")
  } 
  else if(type=="stem") {
    res = matrix(0, ncol=ncoh, nrow = length(psiVec))
    rownames(res) = psiVec
    colnames(res) = cohortnames
    
    for(i in 1:ncoh) {
      kstem = unlist(lapply(psiVec, hydraulics.xylemConductance, VCstem_kmax[i], VCstem_c[i], VCstem_d[i]))
      res[,i] = kstem
      if(draw) {
        if(i==1) {
          plot(-psiVec, kstem, type="l", xlim=c(0,-minPsi), ylim =c(0, max(VCstem_kmax)),
               xlab = "Stem pressure (-MPa)", ylab = expression(paste("Stem conductance  ", (mmol*H[2]*O%.%s^{-1}%.%m^{-2}%.%MPa^{-1}))), col=i)
        } else {
          lines(-psiVec, kstem, lty=i, col=i)
        }
      }
    }
    if(draw) legend("topright", legend = cohortnames, lty=1:ncoh, col = 1:ncoh, bty="n")
  } 
  else if(type=="root") {
    for(i in 1:ncoh) {
      kroot = matrix(NA, ncol=length(psiVec), nrow = nlayer)
      for(j in 1:nlayer) {
        kroot[j,] = unlist(lapply(psiVec, hydraulics.xylemConductance, VCroot_kmax[i,j], VCroot_c[i], VCroot_d[i]))
      }
      if(draw) {
        if(i==1) {
          matplot(-psiVec, t(kroot), type="l", xlim=c(0,-minPsi), ylim =c(0, max(VCroot_kmax)),
                  xlab = "Root pressure (-MPa)", ylab = expression(paste("Root conductance  ", (mmol*H[2]*O%.%s^{-1}%.%m^{-2}%.%MPa^{-1}))), col=col)
        } else {
          matlines(-psiVec, t(kroot), lty=i, col=col)
        }
      }
    }
    if(draw) {
      legend("topright", legend = cohortnames, lty=1:ncoh, bty="n")
      legend("right", legend = paste("Layer", 1:nlayer), lty=1, col=col, bty="n")
    }
  } 
  else if(type=="rhizosphere") {
    if(is.null(soil)) stop("Please supply a non-null soil object!")
    VG_nc = soil$VG_n
    VG_alphac = soil$VG_alpha
    for(i in 1:ncoh) {
      krhizo = matrix(NA, ncol=length(psiVec), nrow = nlayer)
      for(j in 1:nlayer) {
        krhizo[j,] = unlist(lapply(psiVec, hydraulics.vanGenuchtenConductance, VGrhizo_kmax[i,j], VG_nc[j], VG_alphac[j]))
      }
      if(i==1) {
        matplot(-psiVec, t(krhizo), type="l", xlim=c(0,-minPsi), ylim =c(0,100),
                xlab = "Rhizosphere pressure (-MPa)", ylab = expression(paste("Rhizosphere conductance  ", (mmol*H[2]*O%.%s^{-1}%.%m^{-2}%.%MPa^{-1}))), col=col)
      } else {
        matlines(-psiVec, t(krhizo), lty=i, col=col)
      }
    }
    legend("topright", legend = cohortnames, lty=1:ncoh, bty="n")
    legend("right", legend = paste("Layer", 1:nlayer), lty=1, col=col, bty="n")
  } 
  if(draw) invisible(res)
  else return(res)
}