% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_binaryclass.R
\name{TP}
\alias{TP}
\title{True positives}
\usage{
TP(truth, response, positive)
}
\arguments{
\item{truth}{vector of true values}

\item{response}{vector of predicted values}

\item{positive}{positive class}
}
\description{
Sum of all correctly classified observations in the positive class.
}
\examples{
n = 20
set.seed(125)
truth = as.factor(sample(c(1,0), n, replace = TRUE))
probabilities = runif(n)
response = as.factor(as.numeric(probabilities > 0.5))
positive = 1
TP(truth, response, positive)
}
