% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_multiclass.R
\name{multiclass.AUNU}
\alias{multiclass.AUNU}
\title{Average 1 vs. rest multiclass AUC}
\usage{
multiclass.AUNU(probabilities, truth)
}
\arguments{
\item{probabilities}{[numeric] matrix of predicted probabilities with columnnames of the classes}

\item{truth}{vector of true values}
}
\description{
Computes the AUC treating a c-dimensional classifier as c two-dimensional classifiers, 
where classes are assumed to have uniform distribution, in order to have a measure which is 
independent of class distribution change. 
See Ferri et al.: https://www.math.ucdavis.edu/~saito/data/roc/ferri-class-perf-metrics.pdf.
}
\examples{
n = 20
set.seed(122)
truth = as.factor(sample(c(1,2,3), n, replace = TRUE))
probabilities = matrix(runif(60), 20, 3)
probabilities = probabilities/rowSums(probabilities)
colnames(probabilities) = c(1,2,3)
multiclass.AUNU(probabilities, truth)
}
