% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R
\name{frate_counts}
\alias{frate_counts}
\title{Estimate population firing rate using fixed-width time bins.}
\usage{
frate_counts(spikes, beg, end, wid, nbins)
}
\arguments{
\item{spikes}{List of simultaneously recorded spike trains}

\item{beg}{Start of the recording, in seconds.}

\item{end}{The start time of  the last bin, in seconds.}

\item{wid}{The duration of each bin}

\item{nbins}{The number of bins to generate.}
}
\value{
The population firing rate (in Hz) for each bin.
}
\description{
Estimate the population firing rate, averaging over all spikes.
}
\details{
We compute the array-wide average activity for a list of spike
trains.  The duration of the recording is given in seconds by BEG
and END.  Time is divided up into NBINS bins, each of duration WID.  Each spike
is then placed in the appropriate bin and then we return the average count in each bin.
}
\author{
Stephen Eglen
}
