/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.initial;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;

public class LogManager {
    public static final Logger LOG = Logger.getLogger("Dendro");

    public LogManager(String string, LogType logType) {
        try {
            FileHandler fileHandler = new FileHandler(string);
            LOG.addHandler(fileHandler);
            if (logType.equals((Object)LogType.TXT)) {
                SimpleFormatter simpleFormatter = new SimpleFormatter();
                fileHandler.setFormatter(simpleFormatter);
            } else {
                XMLFormatter xMLFormatter = new XMLFormatter();
                fileHandler.setFormatter(xMLFormatter);
            }
            LOG.setLevel(Level.CONFIG);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        LOG.config("Log started");
    }

    public static void setLevel(Level level) {
        LOG.setLevel(level);
    }

    public static enum LogType {
        TXT,
        XML;

    }
}

