/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.forms;

import multidendrograms.definitions.BoxContainer;
import multidendrograms.definitions.Config;
import multidendrograms.definitions.Dimensions;
import multidendrograms.definitions.SettingsInfo;
import multidendrograms.dendrogram.Scaling;
import multidendrograms.initial.InitialProperties;
import multidendrograms.types.DendrogramOrientation;
import multidendrograms.types.LabelOrientation;
import multidendrograms.utils.TextBoxSize;

public class XYBox {
    private Scaling scalingDendro = null;
    private Scaling scalingBullets = null;
    private Scaling scalingAxis = null;
    private Scaling scalingAxisLabels = null;

    public XYBox(Config config, double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = InitialProperties.getSizeDendroMargin();
        SettingsInfo settingsInfo = config.getSettingsInfo();
        DendrogramOrientation dendrogramOrientation = config.getDendrogramOrientation();
        double d8 = config.getRadius();
        Dimensions<Double> dimensions = this.getDimensionsBullets(config);
        Dimensions<Double> dimensions2 = this.getDimensionsNodesNames(config);
        Dimensions<Double> dimensions3 = this.getDimensionsAxis(config);
        Dimensions<Double> dimensions4 = this.getDimensionsAxisLabels(config);
        if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) || dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            d6 = dimensions3.getWidth() + dimensions4.getWidth() + 2.0 * d8;
            d5 = dimensions2.getHeight() + dimensions.getHeight() + 2.0 * d8;
        } else {
            d6 = dimensions2.getWidth() + dimensions.getWidth() + 2.0 * d8;
            d5 = dimensions3.getHeight() + dimensions4.getHeight() + 2.0 * d8;
        }
        DendrogramOrientation dendrogramOrientation2 = settingsInfo.getDendrogramAdaptedOrientation();
        if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) || dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            d4 = d - (d6 + 2.0 * d7 + dimensions2.getWidth());
            d3 = d2 - (d5 + 2.0 * d7);
        } else {
            d4 = d - (d6 + 2.0 * d7);
            d3 = d2 - (d5 + 2.0 * d7 + dimensions2.getHeight());
        }
        BoxContainer boxContainer = this.getBoxDendrogram(config, dendrogramOrientation2, dimensions2, d6, d5, d4, d3);
        BoxContainer boxContainer2 = this.getBoxBullets(config, dendrogramOrientation2, dimensions, d4, d3, boxContainer);
        BoxContainer boxContainer3 = this.getBoxAxis(config, dimensions3, dimensions4, d4, d3, boxContainer);
        BoxContainer boxContainer4 = this.getBoxAxisLabels(config, dimensions3, dimensions4, d4, d3, boxContainer);
        boxContainer.increaseCornerY(-d2);
        boxContainer2.increaseCornerY(-d2);
        boxContainer3.increaseCornerY(-d2);
        boxContainer4.increaseCornerY(-d2);
        this.scalingDendro = new Scaling(boxContainer);
        this.scalingBullets = new Scaling(boxContainer2);
        this.scalingAxis = new Scaling(boxContainer3);
        this.scalingAxisLabels = new Scaling(boxContainer4);
    }

    private Dimensions<Double> getDimensionsBullets(Config config) {
        SettingsInfo settingsInfo = config.getSettingsInfo();
        DendrogramOrientation dendrogramOrientation = config.getDendrogramOrientation();
        int n = config.getHierarchicalClustering().getRoot().numberOfLeaves();
        double d = config.getRadius();
        double d2 = settingsInfo.getNodeRadius();
        double d3 = 0.0;
        double d4 = 0.0;
        if (d2 > 0.0) {
            if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) || dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
                d3 = this.boxNodesWidth(n, d);
                d4 = 2.0 * d2;
            } else {
                d3 = 2.0 * d2;
                d4 = this.boxNodesWidth(n, d);
            }
        }
        Dimensions<Double> dimensions = new Dimensions<Double>(d3, d4);
        return dimensions;
    }

    private Dimensions<Double> getDimensionsNodesNames(Config config) {
        Object object;
        SettingsInfo settingsInfo = config.getSettingsInfo();
        double d = 0.0;
        double d2 = 0.0;
        if (settingsInfo.isNodeNameVisible()) {
            object = config.getNodeNameOrientation();
            int n = object.equals((Object)LabelOrientation.HORIZONTAL) ? 0 : (object.equals((Object)LabelOrientation.OBLIQUE) ? 45 : -90);
            TextBoxSize textBoxSize = new TextBoxSize(settingsInfo.getNodeNameFont());
            String[] stringArray = config.getNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Dimensions<Double> dimensions = textBoxSize.getBox(n, stringArray[i]);
                d = Math.max(d, dimensions.getWidth());
                d2 = Math.max(d2, dimensions.getHeight());
            }
        }
        object = new Dimensions<Double>(d, d2);
        return object;
    }

    private Dimensions<Double> getDimensionsAxis(Config config) {
        SettingsInfo settingsInfo = config.getSettingsInfo();
        DendrogramOrientation dendrogramOrientation = config.getDendrogramOrientation();
        double d = config.getRadius();
        double d2 = config.getAxisMaxValue() - config.getAxisMinValue();
        double d3 = 0.0;
        double d4 = 0.0;
        if (settingsInfo.isAxisVisible()) {
            if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) || dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
                d3 = 2.0 * d;
                d4 = d2;
            } else {
                d3 = d2;
                d4 = 2.0 * d;
            }
        }
        Dimensions<Double> dimensions = new Dimensions<Double>(d3, d4);
        return dimensions;
    }

    private Dimensions<Double> getDimensionsAxisLabels(Config config) {
        SettingsInfo settingsInfo = config.getSettingsInfo();
        DendrogramOrientation dendrogramOrientation = config.getDendrogramOrientation();
        Dimensions<Double> dimensions = new Dimensions<Double>(0.0, 0.0);
        if (settingsInfo.isAxisLabelVisible()) {
            TextBoxSize textBoxSize = new TextBoxSize(settingsInfo.getAxisLabelFont());
            int n = (int)Math.round(config.getAxisMaxValue());
            String string = Integer.toString(n);
            int n2 = string.trim().length();
            int n3 = config.getAxisLabelDecimals();
            dimensions = dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) || dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH) ? (config.isDistance() ? textBoxSize.getBoxPositiveNumber(0.0, n2, n3) : textBoxSize.getBoxNegativeNumber(0.0, n2, n3)) : (config.isDistance() ? textBoxSize.getBoxPositiveNumber(90.0, n2, n3) : textBoxSize.getBoxNegativeNumber(90.0, n2, n3));
        }
        return dimensions;
    }

    private BoxContainer getBoxDendrogram(Config config, DendrogramOrientation dendrogramOrientation, Dimensions<Double> dimensions, double d, double d2, double d3, double d4) {
        double d5 = InitialProperties.getSizeDendroMargin();
        int n = config.getHierarchicalClustering().getRoot().numberOfLeaves();
        double d6 = config.getRadius();
        double d7 = config.getAxisMinValue();
        double d8 = config.getAxisMaxValue();
        BoxContainer boxContainer = new BoxContainer();
        double d9 = dendrogramOrientation.equals((Object)DendrogramOrientation.WEST) ? d5 : d + d5;
        double d10 = dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) ? d2 + d5 : d5;
        boxContainer.setCornerX(d9);
        if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) || dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            boxContainer.setCornerY(d10);
        } else {
            boxContainer.setCornerY(d10 + dimensions.getHeight());
        }
        boxContainer.setWidth(d3);
        boxContainer.setHeight(d4);
        if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) || dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            boxContainer.setValMinX(0.0);
            boxContainer.setValMaxX(this.boxNodesWidth(n, d6));
            boxContainer.setValMinY(d7);
            boxContainer.setValMaxY(d8);
        } else {
            boxContainer.setValMinX(d7);
            boxContainer.setValMaxX(d8);
            boxContainer.setValMinY(0.0);
            boxContainer.setValMaxY(this.boxNodesWidth(n, d6));
        }
        return boxContainer;
    }

    private BoxContainer getBoxBullets(Config config, DendrogramOrientation dendrogramOrientation, Dimensions<Double> dimensions, double d, double d2, BoxContainer boxContainer) {
        double d3;
        double d4;
        double d5;
        double d6;
        int n = config.getHierarchicalClustering().getRoot().numberOfLeaves();
        double d7 = config.getRadius();
        if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH)) {
            d6 = boxContainer.getCornerX();
            d5 = boxContainer.getCornerY() - d7 + 1.0;
        } else if (dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            d6 = boxContainer.getCornerX();
            d5 = boxContainer.getCornerY() + d2 - d7 + 1.0;
        } else if (dendrogramOrientation.equals((Object)DendrogramOrientation.WEST)) {
            d6 = boxContainer.getCornerX() + d - d7 + 1.0;
            d5 = boxContainer.getCornerY();
        } else {
            d6 = boxContainer.getCornerX() - d7 + 1.0;
            d5 = boxContainer.getCornerY();
        }
        if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) || dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            d4 = d;
            d3 = dimensions.getHeight();
        } else {
            d4 = dimensions.getWidth();
            d3 = d2;
        }
        BoxContainer boxContainer2 = new BoxContainer();
        boxContainer2.setCornerX(d6);
        boxContainer2.setCornerY(d5);
        boxContainer2.setWidth(d4);
        boxContainer2.setHeight(d3);
        if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) || dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            boxContainer2.setValMinX(0.0);
            boxContainer2.setValMaxX(this.boxNodesWidth(n, d7));
            boxContainer2.setValMinY(0.0);
            boxContainer2.setValMaxY(d7);
        } else {
            boxContainer2.setValMinX(0.0);
            boxContainer2.setValMaxX(d7);
            boxContainer2.setValMinY(0.0);
            boxContainer2.setValMaxY(this.boxNodesWidth(n, d7));
        }
        return boxContainer2;
    }

    private BoxContainer getBoxAxis(Config config, Dimensions<Double> dimensions, Dimensions<Double> dimensions2, double d, double d2, BoxContainer boxContainer) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = InitialProperties.getSizeDendroMargin();
        double d8 = config.getRadius();
        DendrogramOrientation dendrogramOrientation = config.getDendrogramOrientation();
        double d9 = config.getAxisMinValue();
        double d10 = config.getAxisMaxValue();
        if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) || dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            d6 = dimensions2.getWidth() + d8 + d7;
            d5 = boxContainer.getCornerY();
            d4 = dimensions.getWidth();
            d3 = d2;
        } else {
            d6 = boxContainer.getCornerX();
            d5 = boxContainer.getCornerY() + d2 + d8;
            d4 = d;
            d3 = dimensions.getHeight();
        }
        BoxContainer boxContainer2 = new BoxContainer();
        boxContainer2.setCornerX(d6);
        boxContainer2.setCornerY(d5);
        boxContainer2.setWidth(d4);
        boxContainer2.setHeight(d3);
        if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) || dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            boxContainer2.setValMinX(0.0);
            boxContainer2.setValMaxX(2.0);
            boxContainer2.setValMinY(d9);
            boxContainer2.setValMaxY(d10);
        } else {
            boxContainer2.setValMinX(d9);
            boxContainer2.setValMaxX(d10);
            boxContainer2.setValMinY(0.0);
            boxContainer2.setValMaxY(2.0);
        }
        return boxContainer2;
    }

    private BoxContainer getBoxAxisLabels(Config config, Dimensions<Double> dimensions, Dimensions<Double> dimensions2, double d, double d2, BoxContainer boxContainer) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = InitialProperties.getSizeDendroMargin();
        double d8 = config.getRadius();
        DendrogramOrientation dendrogramOrientation = config.getDendrogramOrientation();
        double d9 = config.getAxisMinValue();
        double d10 = config.getAxisMaxValue();
        if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) || dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            d6 = d7;
            d5 = boxContainer.getCornerY();
            d4 = dimensions2.getWidth();
            d3 = d2;
        } else {
            d6 = boxContainer.getCornerX();
            d5 = boxContainer.getCornerY() + d2 + dimensions.getHeight() + 2.0 * d8;
            d4 = d;
            d3 = dimensions2.getHeight();
        }
        BoxContainer boxContainer2 = new BoxContainer();
        boxContainer2.setCornerX(d6);
        boxContainer2.setCornerY(d5);
        boxContainer2.setWidth(d4);
        boxContainer2.setHeight(d3);
        if (dendrogramOrientation.equals((Object)DendrogramOrientation.NORTH) || dendrogramOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            boxContainer2.setValMinX(0.0);
            boxContainer2.setValMaxX(dimensions2.getWidth());
            boxContainer2.setValMinY(d9);
            boxContainer2.setValMaxY(d10);
        } else {
            boxContainer2.setValMinX(d9);
            boxContainer2.setValMaxX(d10);
            boxContainer2.setValMinY(0.0);
            boxContainer2.setValMaxY(dimensions2.getHeight());
        }
        return boxContainer2;
    }

    private double boxNodesWidth(int n, double d) {
        return 2.0 * d * (double)n + (double)(n - 1) * d;
    }

    public Scaling getScalingDendrogram() {
        return this.scalingDendro;
    }

    public Scaling getScalingBullets() {
        return this.scalingBullets;
    }

    public Scaling getScalingAxis() {
        return this.scalingAxis;
    }

    public Scaling getScalingAxisLabels() {
        return this.scalingAxisLabels;
    }
}

