\name{simcares}
\alias{simcares}

\title{
Results of SIMCA one-class classification
}

\description{
\code{simcares} is used to store results for SIMCA one-class classification.
}

\usage{
simcares(pres, cres)
}
\arguments{
  \item{pres}{results of PCA decomposition of data (class \code{pcares}).}
  \item{cres}{results of classification (class \code{classres}).}
}

\details{
Class \code{simcares} inherits all properties and methods of class \code{\link{pcares}}, and 
has additional properties and functions for representing of classification results, inherited from class \code{\link{classres}}.

There is no need to create a \code{simcares} object manually, it is created automatically when build a SIMCA model (see \code{\link{simca}}) or apply the model to a new data (see \code{\link{predict.simca}}). The object can be used to show summary and plots for the results.
}

\value{
Returns an object (list) of class \code{simcares} with the same fields as \code{\link{pcares}} plus extra fields, inherited from \code{\link{classres}}:
\item{c.pred}{predicted class values (+1 or -1).}
\item{c.ref}{reference (true) class values if provided.}

The following fields are available only if reference values were provided.
\item{tp}{number of true positives.}
\item{fp}{nmber of false positives.}
\item{fn}{number of false negatives.}
\item{specificity}{specificity of predictions.}
\item{sensitivity}{sensitivity of predictions.}
}

\author{
Sergey Kucheryavskiy (svkucheryavski@gmail.com)
}


\seealso{
Methods for \code{simcares} objects:
  \tabular{ll}{
      \code{print.simcares} \tab shows information about the object.\cr
      \code{summary.simcares} \tab shows statistics for results of classification.\cr
   }
   
Methods, inherited from \code{\link{classres}} class:
  \tabular{ll}{
      \code{\link{showPredictions.classres}} \tab show table with predicted values.\cr
      \code{\link{plotPredictions.classres}} \tab makes plot with predicted values.\cr
      \code{\link{plotSensitivity.classres}} \tab makes plot with sensitivity vs. components values.\cr
      \code{\link{plotSpecificity.classres}} \tab makes plot with specificity vs. components values.\cr
      \code{\link{plotPerformance.classres}} \tab makes plot with both specificity and sensitivity values.\cr
   }

Methods, inherited from \code{\link{ldecomp}} class:   
  \tabular{ll}{
      \code{\link{plotResiduals.ldecomp}} \tab makes Q2 vs. T2 residuals plot.\cr
      \code{\link{plotScores.ldecomp}} \tab makes scores plot.\cr
      \code{\link{plotVariance.ldecomp}} \tab makes explained variance plot.\cr
      \code{\link{plotCumVariance.ldecomp}} \tab makes cumulative explained variance plot.\cr
   }
   Check also \code{\link{simca}} and \code{\link{pcares}}.    
}

\examples{
## make a SIMCA model for Iris setosa class and show results for calibration set
library(mdatools)

data = iris[, 1:4]
class = iris[, 5]

# take first 30 objects of setosa as calibration set 
se = data[1:30, ]

# make SIMCA model and apply to test set
model = simca(se, 'Se')
model = selectCompNum(model, 1)

# show infromation and summary
print(model$calres)
summary(model$calres)

# show plots
layout(matrix(c(1,1,2,3), 2, 2, byrow = TRUE))
plotPredictions(model$calres, show.labels = TRUE)
plotResiduals(model$calres, show.labels = TRUE)
plotPerformance(model$calres, show.labels = TRUE, legend.position = 'bottomright')
layout(1, 1, 1)

# show predictions table
showPredictions(model$calres)

}

