% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsres.R
\name{plotXResiduals.plsres}
\alias{plotXResiduals.plsres}
\title{X residuals plot for PLS results}
\usage{
\method{plotXResiduals}{plsres}(
  obj,
  ncomp = obj$ncomp.selected,
  norm = TRUE,
  log = FALSE,
  main = sprintf("X-residuals (ncomp = \%d)", ncomp),
  ...
)
}
\arguments{
\item{obj}{PLS results (object of class \code{plsres})}

\item{ncomp}{how many components to use (if NULL - user selected optimal value will be used)}

\item{norm}{logical, normalize distance values or not (see details)}

\item{log}{logical, apply log tranformation to the distances or not (see details)}

\item{main}{main title for the plot}

\item{...}{other plot parameters (see \code{mdaplot} for details)}
}
\description{
Shows a plot with Q residuals vs. Hotelling T2 values for PLS decomposition of x data.
}
\details{
See examples in help for \code{\link{plsres}} function.
}
