% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCUnit-package.R
\docType{package}
\name{mcunit-package}
\alias{mcunit}
\alias{mcunit-package}
\title{mcunit: Unit Tests for MC Methods}
\description{
Unit testing for Monte Carlo methods, particularly Markov Chain Monte Carlo (MCMC) methods, are implemented as extensions of the 'testthat' package. The MCMC methods check whether the MCMC chain has the correct invariant distribution. They do not check other properties of successful samplers such as whether the chain can reach all points, i.e. whether is recurrent. The tests require the ability to sample from the prior and to run steps of the MCMC chain. The methodology is described in Gandy and Scott (2020) <arXiv:2001.06465>.
}
\details{
If you want to test an MCMC sampler then the main function
that you are going to need from this package are
\link{expect_mcmc} and \link{expect_mcmc_reversible} which
can be used as part of unit testing in the framework of the
testthat package. They test if MCMC algorithms have the correct
invariant distribution.\preformatted{If you are testing iid samples then [expect_mc_iid_mean],
[expect_mc_iid_ks], [expect_mc_iid_chisq] and [expect_mc_test]
will be useful.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://bitbucket.org/agandy/mcunit/}
}

}
\author{
\strong{Maintainer}: Axel Gandy \email{a.gandy@imperial.ac.uk}

Authors:
\itemize{
  \item James Scott \email{james.scott15@imperial.ac.uk}
}

}
\keyword{internal}
