% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_mctq.R
\name{random_mctq}
\alias{random_mctq}
\title{Build a random MCTQ case}
\usage{
random_mctq(model = "standard")
}
\arguments{
\item{model}{A string indicating the data model to return. Valid values are:
\code{"standard"}, "\verb{shift"}, and \code{"micro"} (default: \code{"standard"}).}
}
\value{
A named \code{list} with elements representing each MCTQ basic/measurable
variable of the model indicated in the \code{model} argument.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{random_mctq} builds a fictional Munich Chronotype Questionnaire (MCTQ) case
composed of MCTQ basic/measurable variables.

This function is \strong{for testing and learning purposes only}. Please don't
misuse it.
}
\details{
The case structure (variable names and classes) are the same as the datasets
provided by the \code{mctq} package. See \link{std_mctq}, \link{micro_mctq} and
\link{shift_mctq} to learn more.
\subsection{Requirements}{

This function requires the \code{\link[stats:stats-package]{stats}} package. This
won't be an issue for most people since the package comes with a standard R
installation.

If you don't have the \code{\link[stats:stats-package]{stats}} package, you can
install it with \code{install.packages("stats")}.
}

\subsection{Cases}{

Random standard and micro MCTQ cases were created with the general
population in mind. The data was set to resemble the distribution parameters
shown in Roenneberg, Wirz-Justice, & Merrow (2003).

MCTQ\eqn{^{Shift}}{ Shift} random cases were created based on the shift
configuration from "Study Site 1" shown in Vetter, Juda, & Roenneberg (2012).
The data was set to resemble the distribution parameters shown in Juda,
Vetter, & Roenneberg (2013).

You can see more about the distribution parameters used
\href{https://github.com/ropensci/mctq/blob/master/data-raw/random_mctq.R}{here}.
}
}
\examples{
\dontrun{
random_mctq("standard")
random_mctq("micro")
random_mctq("shift")
}
}
\references{
Juda, M., Vetter, C., & Roenneberg, T. (2013). The Munich ChronoType
Questionnaire for shift-workers (MCTQ\eqn{^{Shift}}{ Shift}). \emph{Journal of
Biological Rhythms}, \emph{28}(2), 130-140. \doi{10.1177/0748730412475041}.

Roenneberg, T., Wirz-Justice, A., & Merrow, M. (2003). Life between clocks:
daily temporal patterns of human chronotypes. \emph{Journal of Biological
Rhythms}, \emph{18}(1), 80-90. \doi{10.1177/0748730402239679}.

Vetter, C., Juda, M., & Roenneberg, T. (2012). The influence of internal time,
time awake, and sleep duration on cognitive performance in shiftworkers.
\emph{Chronobiology International}, \emph{29}(8), 1127-1138.
\doi{10.3109/07420528.2012.707999}.
}
\seealso{
Other utility functions: 
\code{\link{assign_date}()},
\code{\link{cycle_time}()},
\code{\link{pretty_mctq}()},
\code{\link{qplot_walk}()},
\code{\link{raw_data}()},
\code{\link{round_time}()},
\code{\link{shorter_interval}()},
\code{\link{sum_time}()}
}
\concept{utility functions}
