% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcr.R
\name{calcBias}
\alias{calcBias}
\title{Systematical Bias Between Reference Method and Test Method}
\usage{
calcBias(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[mcr:MCResult.calcBias]{mcr::calcBias}}
  \describe{
    \item{\code{.Object}}{object of class "MCResult".}
  }}
}
\value{
Bis and corresponding confidence interval for the specific medical
decision levels (\code{x.levels}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A copy from \link[mcr:MCResult.calcBias]{mcr::calcBias} in \code{mcr} package
}
\examples{
data(platelet)
fit <- mcreg(
  x = platelet$Comparative, y = platelet$Candidate,
  method.reg = "Deming", method.ci = "jackknife"
)
calcBias(fit, x.levels = c(30, 200))
calcBias(fit, x.levels = c(30, 200), type = "proportional")
calcBias(fit, x.levels = c(30, 200), type = "proportional", percent = FALSE)
}
\seealso{
\code{\link[mcr:MCResult.calcBias]{mcr::calcBias()}}
}
