% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\encoding{UTF-8}
\name{plot.mcpfit}
\alias{plot.mcpfit}
\alias{plot}
\title{Plot full fits}
\usage{
\method{plot}{mcpfit}(
  x,
  facet_by = NULL,
  lines = 25,
  geom_data = "point",
  cp_dens = TRUE,
  q_fit = FALSE,
  q_predict = FALSE,
  rate = TRUE,
  prior = FALSE,
  which_y = "ct",
  arma = TRUE,
  nsamples = 2000,
  scale = "response",
  ...
)
}
\arguments{
\item{x}{An \code{\link{mcpfit}} object}

\item{facet_by}{String. Name of a varying group.}

\item{lines}{Positive integer or \code{FALSE}. Number of lines (posterior
draws). FALSE or \code{lines = 0} plots no lines. Note that lines always plot
fitted values - not predicted. For prediction intervals, see the \code{q_predict} argument.}

\item{geom_data}{String. One of "point", "line" (good for time-series),
or FALSE (don not plot).}

\item{cp_dens}{TRUE/FALSE. Plot posterior densities of the change point(s)?
Currently does not respect \code{facet_by}. This will be added in the future.}

\item{q_fit}{Whether to plot quantiles of the posterior (fitted value).
\itemize{
\item \code{TRUE} Add 2.5\% and 97.5\% quantiles. Corresponds to
\code{q_fit = c(0.025, 0.975)}.
\item \code{FALSE} No quantiles
\item A vector of quantiles. For example, \code{quantiles = 0.5}
plots the median and \code{quantiles = c(0.2, 0.8)} plots the 20\% and 80\%
quantiles.
}}

\item{q_predict}{Same as \code{q_fit}, but for the prediction interval.}

\item{rate}{Boolean. For binomial models, plot on raw data (\code{rate = FALSE}) or
response divided by number of trials (\code{rate = TRUE}). If FALSE, linear
interpolation on trial number is used to infer trials at a particular x.}

\item{prior}{TRUE/FALSE. Plot using prior samples? Useful for \code{mcp(..., sample = "both")}}

\item{which_y}{What to plot on the y-axis. One of
\itemize{
\item \code{"ct"}: The central tendency which is often the mean after applying the
link function.
\item \code{"sigma"}: The variance
\item \code{"ar1"}, \code{"ar2"}, etc. depending on which order of the autoregressive
effects you want to plot.
}}

\item{arma}{Whether to include autoregressive effects.
\itemize{
\item \code{TRUE} Compute autoregressive residuals. Requires the response variable in \code{newdata}.
\item \code{FALSE} Disregard the autoregressive effects. For \code{family = gaussian()}, \code{predict()} just use \code{sigma} for residuals.
}}

\item{nsamples}{Integer or \code{NULL}. Number of samples to return/summarise.
If there are varying effects, this is the number of samples from each varying group.
\code{NULL} means "all". Ignored if both are \code{FALSE}. More samples trade speed for accuracy.}

\item{scale}{One of
\itemize{
\item "response": return on the observed scale, i.e., after applying the inverse link function.
\item "linear": return on the parameter scale (where the linear trends are modelled).
}}

\item{...}{Currently ignored.}
}
\value{
A \pkg{ggplot2} object.
}
\description{
Plot prior or posterior model draws on top of data. Use \code{plot_pars} to
plot individual parameter estimates.
}
\details{
\code{plot()} uses \code{fit$simulate()} on posterior samples. These represent the
(joint) posterior distribution.
}
\examples{
# Typical usage. demo_fit is an mcpfit object.
plot(demo_fit)
\donttest{
plot(demo_fit, prior = TRUE)  # The prior

plot(demo_fit, lines = 0, q_fit = TRUE)  # 95\% HDI without lines
plot(demo_fit, q_predict = c(0.1, 0.9))  # 80\% prediction interval
plot(demo_fit, which_y = "sigma", lines = 100)  # The variance parameter on y

# Show a panel for each varying effect
# plot(fit, facet_by = "my_column")

# Customize plots using regular ggplot2
library(ggplot2)
plot(demo_fit) + theme_bw(15) + ggtitle("Great plot!")
}

}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
