% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cMVN_sampler.R
\name{create_block_cMVN_sampler}
\alias{create_block_cMVN_sampler}
\title{Set up a a function for direct sampling from a constrained multivariate normal distribution}
\usage{
create_block_cMVN_sampler(
  mbs,
  X,
  Q,
  R = NULL,
  r = NULL,
  sampler,
  name = "x",
  chol.control
)
}
\arguments{
\item{mbs}{block component containing several model components.}

\item{X}{design matrix.}

\item{Q}{precision matrix.}

\item{R}{equality restriction matrix.}

\item{r}{rhs vector for equality constraints \eqn{R'x = r}, where \eqn{R'} denotes the transpose of R.}

\item{sampler}{sampler object as created by \code{\link{create_sampler}}.}

\item{name}{name of the cMVN vector parameter.}

\item{chol.control}{options for Cholesky decomposition, see \code{\link{chol_control}}.}
}
\value{
An environment with precomputed quantities and functions for sampling
  from a multivariate normal distribution subject to equality constraints.
}
\description{
Set up a a function for direct sampling from a constrained multivariate normal distribution
}
\keyword{internal}
