% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{acceptance_rates}
\alias{acceptance_rates}
\title{Return Metropolis-Hastings acceptance rates}
\usage{
acceptance_rates(obj, aggregate.chains = FALSE)
}
\arguments{
\item{obj}{an mcdraws object, i.e. the output of function \code{\link{MCMCsim}}.}

\item{aggregate.chains}{whether to return averages over chains or results per chain.}
}
\value{
A list of acceptance rates.
}
\description{
Return Metropolis-Hastings acceptance rates
}
\examples{
\donttest{
ex <- mcmcsae_example()
# specify a model that requires MH sampling (in this case for a modeled
#   degrees of freedom parameter in the variance part of the model)
sampler <- create_sampler(ex$model, data=ex$dat, formula.V=~vfac(factor="fA",
  prior=pr_invchisq(df="modeled")))
sim <- MCMCsim(sampler, burnin=100, n.iter=300, thin=2, n.chain=4, store.all=TRUE)
(summary(sim))
acceptance_rates(sim)
}

}
