% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_complete_data.R
\name{mc_complete_data}
\alias{mc_complete_data}
\title{Complete Data Set with NA}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.
}
\usage{
mc_complete_data(data, id, index, id.exp)
}
\arguments{
\item{data}{a data.frame to be completed with NA.}

\item{id}{name of the column (string) containing the subject id.}

\item{index}{name of the column (string) containing the index to be completed.}

\item{id.exp}{how the index is expected to be for all subjects.}
}
\value{
A data.frame with the same number of observations by subject.
}
\description{
The function \code{mc_complete_data} completes a data
set with NA values for helping to construct the components of the
matrix linear predictor in models that require equal number of
observations by subjects (id).
}
\seealso{
\code{mc_dglm}, \code{mc_ns}, \code{mc_ma} and \code{mc_rw}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
