% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{addWeights}
\alias{addWeights}
\title{Add weights to a multi-objective graph.}
\usage{
addWeights(graph, method = "euclidean", weights = NULL, weight.fun = NULL,
  n = NULL, symmetric = TRUE, ...)
}
\arguments{
\item{graph}{[\code{mcGP}]\cr
Multi-objective graph problem.}

\item{method}{[\code{character(1)}]\cr
Method used to generate weights. Possible values are \dQuote{euclidean}, \dQuote{maximum},
\dQuote{manhatten}, \dQuote{canberra}, \dQuote{binary}, \code{minkowski} or \code{random}.
The latter generates (random) weights utilizing \code{weight.fun}. The remaining
options are passed down to \code{\link[stats]{dist}}, i.e., weights are generated
as distances between the node coordinates.}

\item{weights}{[\code{matrix}]\cr
Square matrix of weights.
If some weights are already assigned, pay attention to the correct dimensions.
If this is passed all other arguments are ignored.
Default is \code{NULL}.}

\item{weight.fun}{[\code{function(m, ...) | NULL}]\cr
Function used to generate weights. The first arument needs to be number of weights
to generate.}

\item{n}{[\code{integer(1)}]\cr
Number of nodes. This is required only if there are no coordinates or no weights
until now.
Default is \code{NULL}, i.e., the number of nodes is extracted from \code{graph}.}

\item{symmetric}{[\code{logical(1)}]\cr
Should the weights be symmetric, i.e., w(i, j) = w(j, i) for each pair i, j of nodes?
Default is \code{TRUE}.}

\item{...}{[any]\cr
Additional arguments passed down to \code{weight.fun} or \code{\link[stats]{dist}}. See
documentation of argument \code{method} for details.}
}
\value{
[\code{mcGP}] Multi-objective graph problem.
}
\description{
\code{addWeights} allows to generate edge weights for a multi-objective
graph instance. The weights can be generated on basis of the node coordinates (in this
case \code{\link[stats]{dist}} is applied with the cooresponding \code{method}).
Alternatively, all kinds of random weights can be generated.
}
\seealso{
Other graph generators: \code{\link{addCenters}},
  \code{\link{addCoordinates}}, \code{\link{mcGP}}
}
