% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_pe.R
\name{mle_pe}
\alias{mle_pe}
\title{Find MLEs for microbiome mixture}
\usage{
mle_pe(
  tab,
  interval = c(0, 1),
  tol = 0.000001,
  check_boundary = FALSE,
  SE = FALSE
)
}
\arguments{
\item{tab}{Dataset of read counts as 3d array of size 3x3x2, genotype in first sample x genotype in second sample x allele in read.}

\item{interval}{Interval to which each parameter should be constrained}

\item{tol}{Tolerance for convergence}

\item{check_boundary}{If TRUE, explicitly check the boundaries of \code{interval}.}

\item{SE}{If TRUE, get estimated standard errors.}
}
\value{
A vector containing the estimates of \code{p} and \code{e} along with the evaluated log likelihood and likelihood ratio test statistics for the hypotheses p=0 and p=1.
}
\description{
Find joint MLEs of p and e for microbiome mixture model
}
\examples{
data(mbmixdata)
mle_pe(mbmixdata)

}
