% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbr.R
\name{mbr}
\alias{mbr}
\title{Compute Cliff's delta and S-value}
\usage{
mbr(df)
}
\arguments{
\item{df}{a data frame with the name of experimental groups or biomonitoring
sites as the first column and the measurement of biomarkers as the
remaining columns.}
}
\value{
\code{mbr} returns a list of length 3: \item{\code{mess}}{a list of
  length 3 confirms the information about \code{df}.}\item{\code{es}}{a data
  frame with 9 columns:\describe{ \item{\code{test_site}}{treatment groups or
  test sites.} \item{\code{ref_site }}{control group or reference site.}
  \item{\code{t_size }}{the sample size of treatment group or test sites.}
  \item{\code{r_size }}{the sample size of control group or reference site.}
  \item{\code{biomarker}}{individual biomarker.} \item{\code{delta}}{the
  Cliff's delta of treatment group or reference site.}
  \item{\code{delta.abs}}{the absolute Cliff's delta.} \item{\code{pval}}{the
  P-Value.} \item{\code{sval}}{the surprisal or S-Value.}}}
  \item{\code{idx}}{a data frame summarizes \code{delta.abs} and their
  average.}
}
\description{
\code{mbr} summarizes Cliff's delta and S-value for multiple groups and
multiple biomarkers.
}
\details{
The header of the first column can be any character, for example,
  'group' or 'site'. The first name appearing in the first column will
  determine the control group or the reference site. The other names will be
  treatment groups or test sites. The header of the remaining columns will
  define the list of biomarkers.
}
\examples{

\donttest{
set.seed(1)
setting <- setpop()
temp <- simul(setting$pop_mean)
mbr(temp$sam)
} #might take more than 5s in some machines

}
