% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_beast2_pkg_installed.R
\name{is_beast2_pkg_installed}
\alias{is_beast2_pkg_installed}
\title{Checks if a BEAST2 package is already installed.}
\usage{
is_beast2_pkg_installed(name)
}
\arguments{
\item{name}{BEAST2 package name}
}
\value{
\itemize{
  \item \code{TRUE} if the BEAST2 package is installed
  \item \code{FALSE} if the BEAST2 package is not installed
  \item \code{NULL} if there is no internet connection
}
}
\description{
To be able to check this, an internet connection is needed.
Without an internet connection, \code{NULL} is returned.
}
\examples{
library(testthat)

if (is_beast2_installed() && curl::has_internet()) {
  print(
    paste(
      "Is the Beasy BEAST2 package installed:",
      is_beast2_pkg_installed("Beasy")
    )
  )
}
}
\seealso{
Use \link{is_beast2_ns_pkg_installed}
  to see if the NS package is installed without an internet connection
}
\author{
Richèl J.C. Bilderbeek
}
