% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{log_byname}
\alias{log_byname}
\title{Logarithm of matrix elements}
\usage{
log_byname(a, base = exp(1))
}
\arguments{
\item{a}{a matrix or list of matrices}

\item{base}{the base of the logarithm (default is \code{exp(1)}, giving the natural logarithm)}
}
\value{
M with each element replaced by its base \code{base} logarithm
}
\description{
Specify the base of the log with \code{base} argument.
}
\examples{
log_byname(exp(1))
m <- matrix(c(10,1,1,100), nrow = 2, dimnames = list(paste0("i", 1:2), paste0("c", 1:2))) \%>\%
  setrowtype("Industry") \%>\% setcoltype("Commodity")
log_byname(m)
log_byname(m, base = 10)
}
