\name{inner.GSCA}
\alias{inner.GSCA}
\title{GSCA inner estimation}
\usage{
  inner.GSCA(S, W, inner.mod)
}
\arguments{
  \item{S}{Covariance matrix of the data.}

  \item{W}{Weight matrix, where the indicators are on
  colums and composites are on the rows.}

  \item{inner.mod}{A square matrix specifying the
  relationships of the composites in the model}
}
\value{
  A matrix of unscaled inner weights \code{E} with the same
  dimesions as \code{inner.mod}.
}
\description{
  This implements the first step of the GSCA estimation
  describe by Hwang & Takane (2004). GSCA inner estimation
  should be used only with GSCA outer estimation.
}
\details{
  The first step of GSCA estimation method, as describe by
  Hwang & Takane (2004), involves estimating all model
  regressions, including also the relationships from
  composites toward indicators in the first step.

  The implementation of GSCA in matrixpls differs from the
  Hwang & Takane (2004) version in that during the first
  step, only regressions between composites are estimated.
  The reason for this is that the relationhips from the
  composites to indicators are simple regressions that are
  simply the covariances between the indicators and
  compositess. Since these covariances need to be
  calculated in the second step, it is more efficient to
  not calculate them during the first step.

  This algorithm is therefore identical to the PLS path
  weighting scheme with the exception that correlations are
  not used for inverse relationships and there is no
  falling back to identity scheme for composites that are
  not connected to other composites.
}
\examples{
# Run the example from plspm package using GSCA estimation

library(plspm)

# load dataset satisfaction
data(satisfaction)

# inner model matrix
IMAG = c(0,0,0,0,0,0)
EXPE = c(1,0,0,0,0,0)
QUAL = c(0,1,0,0,0,0)
VAL = c(0,1,1,0,0,0)
SAT = c(1,1,1,1,0,0)
LOY = c(1,0,0,0,1,0)

inner = rbind(IMAG, EXPE, QUAL, VAL, SAT, LOY)

# reflective relationships
reflective <- matrix(0, 27, 6)
for(lv in 1:6){
	reflective[list(1:5, 6:10, 11:15, 16:19, 20:23, 24:27)[[lv]],lv] <-1
}
# no formative relationships
formative <- matrix(0, 6, 27)

model <- list(inner=inner, reflective=reflective, formative=formative)

# apply matrixpls with GSCA estimators

matrixpls(cor(satisfaction[,1:27]), model, 
					outerEstimators = outer.GSCA, 
					innerEstimator = inner.GSCA)
}
\references{
  Hwang, H., & Takane, Y. (2004). Generalized structured
  component analysis. Psychometrika, 69(1), 81–99.
  doi:10.1007/BF02295841
}
\seealso{
  Other inner estimators: \code{\link{inner.centroid}},
  \code{\link{inner.factor}}, \code{\link{inner.identity}},
  \code{\link{inner.path}}
}

