% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3b.miph.R
\name{miph}
\alias{miph}
\title{Constructor Function for multivariate inhomogeneous phase-type distributions}
\usage{
miph(
  mph = NULL,
  gfun = NULL,
  gfun_pars = NULL,
  alpha = NULL,
  S = NULL,
  structure = NULL,
  dimension = 3,
  variables = NULL,
  scale = 1
)
}
\arguments{
\item{mph}{An object of class \linkS4class{mph}.}

\item{gfun}{Vector of inhomogeneity transforms.}

\item{gfun_pars}{List of parameters for the inhomogeneity functions.}

\item{alpha}{A probability vector.}

\item{S}{A list of sub-intensity matrices.}

\item{structure}{A vector of valid ph structures.}

\item{dimension}{The dimension of the ph structure (if provided).}

\item{variables}{Number of marginals.}

\item{scale}{Scale.}
}
\value{
An object of class \linkS4class{iph}.
}
\description{
Constructor Function for multivariate inhomogeneous phase-type distributions
}
\examples{
under_mph <- mph(structure = c("gcoxian", "general"), dimension = 4)
miph(under_mph, gfun = c("weibull", "pareto"), gfun_pars = list(c(2), c(3)))
}
