% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.mph.R
\name{fit,mph-method}
\alias{fit,mph-method}
\title{Fit Method for mph Class}
\usage{
\S4method{fit}{mph}(
  x,
  y,
  delta = numeric(0),
  stepsEM = 1000,
  equal_marginals = FALSE,
  r = 1,
  maxit = 100,
  reltol = 1e-08
)
}
\arguments{
\item{x}{An object of class \linkS4class{mph}.}

\item{y}{Matrix of data.}

\item{delta}{Matrix with right-censoring indicators. (1 uncensored, 0 right censored)}

\item{stepsEM}{Number of EM steps to be performed.}

\item{equal_marginals}{Logical. If TRUE, all marginals are fitted to be equal.}

\item{r}{Sub-sampling parameter, defaults to 1.}

\item{maxit}{Maximum number of iterations when optimizing g function.}

\item{reltol}{Relative tolerance when optimizing g function.}
}
\description{
Fit Method for mph Class
}
\examples{
x <- mph(structure = c("general", "coxian"), dimension = 3)
data <- sim(x, 100)
fit(x = x, y = data, stepsEM = 20)

}
