% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowQuantiles.R
\name{rowQuantiles}
\alias{rowQuantiles}
\alias{colQuantiles}
\title{Estimates quantiles for each row (column) in a matrix}
\usage{
rowQuantiles(x, rows = NULL, cols = NULL, probs = seq(from = 0, to = 1,
  by = 0.25), na.rm = FALSE, type = 7L, ..., useNames = TRUE,
  drop = TRUE)

colQuantiles(x, rows = NULL, cols = NULL, probs = seq(from = 0, to = 1,
  by = 0.25), na.rm = FALSE, type = 7L, ..., useNames = TRUE,
  drop = TRUE)
}
\arguments{
\item{x}{An \code{\link[base]{integer}}, \code{\link[base]{numeric}} or
\code{\link[base]{logical}} NxK \code{\link[base]{matrix}} with N >= 0.}

\item{rows}{A \code{\link[base]{vector}} indicating subset of rows to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{cols}{A \code{\link[base]{vector}} indicating subset of columns to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{probs}{A \code{\link[base]{numeric}} \code{\link[base]{vector}} of J
probabilities in [0, 1].}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, missing values are
excluded.}

\item{type}{An \code{\link[base]{integer}} specify the type of estimator.
See \code{\link[stats]{quantile}} for more details.}

\item{...}{Additional arguments passed to \code{\link[stats]{quantile}}.}

\item{useNames}{If \code{\link[base]{NA}}, the default behavior of the 
function about naming support is remained. If \code{\link[base:logical]{FALSE}}, 
no naming support is done. Else if \code{\link[base:logical]{TRUE}}, names 
attributes of result are set.}

\item{drop}{If TRUE, singleton dimensions in the result are dropped,
otherwise not.}
}
\value{
Returns a NxJ (KxJ) \code{\link[base]{matrix}}, where N (K) is the
number of rows (columns) for which the J quantiles are calculated.
The return type is either integer or numeric depending on \code{type}.
}
\description{
Estimates quantiles for each row (column) in a matrix.
}
\examples{
set.seed(1)

x <- matrix(rnorm(50 * 40), nrow = 50, ncol = 40)
str(x)

probs <- c(0.25, 0.5, 0.75)

# Row quantiles
q <- rowQuantiles(x, probs = probs)
print(q)
q_0 <- apply(x, MARGIN = 1, FUN = quantile, probs = probs)
stopifnot(all.equal(q_0, t(q)))

# Column IQRs
q <- colQuantiles(x, probs = probs)
print(q)
q_0 <- apply(x, MARGIN = 2, FUN = quantile, probs = probs)
stopifnot(all.equal(q_0, t(q)))
}
\seealso{
\code{\link[stats]{quantile}}.
}
\author{
Henrik Bengtsson
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
