## ----nomessages, echo = FALSE--------------------------------------------
knitr::opts_chunk$set(
  warning = FALSE,
  message = FALSE,
  fig.height = 5,
  fig.width = 5
)
options(digits=4)
par(mar=c(5,4,1,1)+.1)

## ------------------------------------------------------------------------
library(matlib)

## ------------------------------------------------------------------------
A <-matrix(c(4, 4, -2,
             4, 4, -2,
            -2, -2, 10), nrow=3, ncol=3, byrow=TRUE)
det(A)

## ------------------------------------------------------------------------
R(A)

## ------------------------------------------------------------------------
echelon(A)

## ------------------------------------------------------------------------
try(inv(A))

## ------------------------------------------------------------------------
(AI <- Ginv(A))

## ------------------------------------------------------------------------
Ginv(A, fractions=TRUE)

## ------------------------------------------------------------------------
A %*% AI %*% A
AI %*% A %*% AI

## ------------------------------------------------------------------------
zapsmall(A %*% AI)
zapsmall(AI %*% A)

## ------------------------------------------------------------------------
A <- cbind( 1, matrix(c(1, 0, 1, 0, 0, 1, 0, 1), nrow=4, byrow=TRUE))
A

## ------------------------------------------------------------------------
R(A)

(AA <- t(A) %*% A)
(AAI <- Ginv(AA))

## ------------------------------------------------------------------------
AI <- AAI  %*%  t(A)

## ------------------------------------------------------------------------
A %*% AI %*% A
AI %*% A %*% AI

